/****************************************************************************
** $Id: qlcdnumber.i,v 1.1.1.1 2002/12/22 14:20:06 taka-hr Exp $
**
** Definition of QLCDNumber class
**
** Created : 940518
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QLCDNUMBER_H
//#define QLCDNUMBER_H

//#ifndef QT_H
//#include "qframe.h"
//#include "qbitarray.h"
//#endif // QT_H


class QLCDNumberPrivate;

class  QLCDNumber : public QFrame		// LCD number widget
{
/*
		Q_OBJECT
		Q_ENUMS( Mode SegmentStyle )
		Q_PROPERTY( bool smallDecimalPoint READ smallDecimalPoint WRITE setSmallDecimalPoint )
		Q_PROPERTY( int numDigits READ numDigits WRITE setNumDigits )
		Q_PROPERTY( Mode mode READ mode WRITE setMode )
		Q_PROPERTY( SegmentStyle segmentStyle READ segmentStyle WRITE setSegmentStyle )
		Q_PROPERTY( double value READ value WRITE display )
		Q_PROPERTY( int intValue READ intValue WRITE display )
*/
public:
%extend{
			QLCDNumber(VALUE varg0=Qnil,VALUE varg1=Qnil, VALUE varg2=Qnil) {
				 if(varg0 ==Qnil) {
						return new QLCDNumber();
				 } else if(TYPE(varg0) == T_FIXNUM) {
						uint numDigits;
						QWidget* parent=0;
						char* name=0;
						numDigits = (uint)NUM2INT(varg0);
						if(varg1 !=Qnil ) parent = (QWidget *)Get_QWidget(varg1);
						if(varg2 !=Qnil ) name = STR2CSTR(varg2);
						return new QLCDNumber(numDigits, parent, name);
				 } else if(rb_obj_is_kind_of(varg0,cQWidget)  || TYPE(varg0) == T_NIL) {
						QWidget* parent;
						char* name=0;
						parent = (QWidget *)Get_QWidget(varg0);
						if(varg1 !=Qnil) name = STR2CSTR(varg1);
						return new QLCDNumber(parent,name);
				 } else {
						rb_raise(rb_eArgError,"Type Error in QLCDNumbere constructor");
				 }
			}
	 };
								 
//    QLCDNumber( QWidget *parent=0, const char *name=0 );
//    QLCDNumber( uint numDigits, QWidget *parent=0, const char *name=0 );
//   ~QLCDNumber();

		enum Mode { Hex, HEX=Hex, Dec, DEC=Dec, Oct, OCT=Oct, Bin, BIN=Bin };
		enum SegmentStyle { Outline, Filled, Flat };

//Q_PROPERTY functions
//    bool smallDecimalPoint();
//    void setSmallDecimalPoint(bool bl);
//    int numDigits();
//    void setNumDigits(int i);
//    Mode mode();
//    void setMode(Mode m);
//    SegmentStyle segmentStyle();
//    void setSegmentStyle(SegmentStyle sg);
//    int intValue();
//    void setIntValue(int i);



		bool    smallDecimalPoint() const;

		int	    numDigits() const;
		virtual void setNumDigits( int nDigits );

//    bool    checkOverflow( double num ) const;
		//RENAME %name(checkOverflowInt) bool    checkOverflow( int	  num ) const;
		%extend {
			 bool checkOverFlow(VALUE varg0) {
					if(TYPE(varg0) == T_FIXNUM) {
						 int num;
						 num = NUM2INT(varg0);
						 return self->checkOverflow(num);
					} else if(TYPE(varg0) == T_FLOAT) {
						 double num;
						 num = NUM2DBL(varg0);
						 return self->checkOverflow(num);
					} else {
						 rb_raise(rb_eArgError,"Error in checkOverflow() argments");
					}
			}
	 } 

		Mode mode() const;
		virtual void setMode( Mode );

		SegmentStyle segmentStyle() const;
		virtual void setSegmentStyle( SegmentStyle );

		double  value() const;
		int	    intValue() const;

		QSize sizeHint() const;
		QSizePolicy sizePolicy() const;

//public slots:
//    void    display( int num );
		//RENAME %name(displayDouble) void    display( double num );
		//RENAME %name(displayQString) void    display( const QString &str );
		%extend {
			 void display(VALUE varg0) {
					if(TYPE(varg0) == T_FIXNUM) {
						 int num;
						 num = NUM2INT(varg0);
						 self->display(num);
					} else if(TYPE(varg0) == T_FLOAT) {
						 double num;
						 num = NUM2DBL(varg0);
						 self->display(num);
					} else {
						 QString* str;
						 str = (QString *)Get_QString(varg0);
						 self->display(*str);
					}
			 }
		}
 
		virtual void setHexMode();
		virtual void setDecMode();
		virtual void setOctMode();
		virtual void setBinMode();
		virtual void setSmallDecimalPoint( bool );
/*
signals:
		void    overflow();

protected:
		void    drawContents( QPainter * );

private:
		void    init();
		void    internalDisplay( const QString &);
		void    internalSetString( const QString& s );
		void    drawString( const QString& s, QPainter &, QBitArray * = 0,
			bool = TRUE );
		//void    drawString( const QString &, QPainter &, QBitArray * = 0 ) const;
		void    drawDigit( const QPoint &, QPainter &, int, char,
		       char = ' ' );
		void    drawSegment( const QPoint &, char, QPainter &, int, bool = FALSE );

		int	    ndigits;
		double  val;
		uint    base	: 2;
		uint    smallPoint	: 1;
		uint    fill	: 1;
		uint    shadow	: 1;
		QString digitStr;
		QBitArray points;
		QLCDNumberPrivate * d;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QLCDNumber( const QLCDNumber & );
		QLCDNumber &operator=( const QLCDNumber & );
#endif
*/
};


//#endif // QLCDNUMBER_H
