/****************************************************************************
** $Id: qmessagebox.i,v 1.1.1.1 2002/12/22 14:20:09 taka-hr Exp $
**
** Definition of QMessageBox class
**
** Created : 950503
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QMESSAGEBOX_H
//#define QMESSAGEBOX_H

//#ifndef QT_H
//#include "qdialog.h"
//#endif // QT_H

class  QLabel;
class  QPushButton;
struct QMBData;

class QMessageBox : public QDialog
{
/*
		Q_OBJECT
		Q_ENUMS( Icon )
		Q_PROPERTY( QString text READ text WRITE setText )
		Q_PROPERTY( Icon icon READ icon WRITE setIcon )
		Q_PROPERTY( QPixmap iconPixmap READ iconPixmap WRITE setIconPixmap )
		Q_PROPERTY( TextFormat textFormat READ textFormat WRITE setTextFormat )
*/
public:
		enum Icon { NoIcon = 0, Information = 1, Warning = 2, Critical = 3 };

//    QMessageBox( QWidget *parent=0, const char *name=0 );
		QMessageBox( const QString& caption, const QString &text, Icon icon,
		 int button0, int button1, int button2,
		 QWidget *parent=0, const char *name=0, bool modal=TRUE,
		 WFlags f=WStyle_DialogBorder  );
	 ~QMessageBox();

		enum { NoButton = 0, Ok = 1, Cancel = 2, Yes = 3, No = 4, Abort = 5,
	   Retry = 6, Ignore = 7, ButtonMask = 0x07,
	   Default = 0x100, Escape = 0x200, FlagMask = 0x300 };

//const char* name () const; //dummy for swig

		//static int information( QWidget *parent, const QString &caption,
		//			    const QString& text,
		//			    int button0, int button1=0, int button2=0 );

		//RENAME %name(informationButtonText) static int information( QWidget *parent, const QString &caption,
		//RENAME			    const QString& text,
		//RENAME			    const QString& button0Text = QString::null,
		//RENAME			    const QString& button1Text = QString::null,
		//RENAME			    const QString& button2Text = QString::null,
		//RENAME			    int defaultButtonNumber = 0,
		//RENAME			    int escapeButtonNumber = -1 );
		%extend {
			 static int information(VALUE varg0, VALUE varg1,
															VALUE varg2, VALUE varg3=Qnil,
															VALUE varg4=Qnil, VALUE varg5=Qnil,			    
															VALUE varg6=Qnil, VALUE varg7=Qnil ) {
			 QWidget* parent;
			 QString* caption;
			 QString* text;
			 parent = (QWidget *)Get_QWidget(varg0);
			 caption = (QString *)Get_QString(varg1);
			 text = (QString *)Get_QString(varg2);
			 if(TYPE(varg3) == T_FIXNUM) {
					int button0;
					int button1=0;
					int button2=0;
					button0 = NUM2INT(varg3);
					if(varg4 != Qnil)
							button1 = NUM2INT(varg4);
					if(varg5 != Qnil)
							button2 = NUM2INT(varg5);
					return QMessageBox::information(parent,*caption,*text,button0,button1,button2);
			 } else {
					QString button0Text = QString::null;
					QString button1Text = QString::null;
					QString button2Text = QString::null;
					QString *button0Textp;
					QString *button1Textp;
					QString *button2Textp;
					int defaultButtonNumber = 0;
					int escapeButtonNumber = -1;
					if(varg3 != Qnil) {
							 button0Textp = (QString *)Get_QString(varg3);
					} else {
							button0Textp = &button0Text;
					}
					if(varg4 != Qnil) {
							 button1Textp = (QString *)Get_QString(varg4);
					} else {
							button1Textp = &button1Text;
					}
					if(varg5 != Qnil) {
							 button2Textp = (QString *)Get_QString(varg5);
					} else {
							button2Textp = &button2Text;
					}
					if(varg6 != Qnil)
							defaultButtonNumber = NUM2INT(varg6);
					if(varg7 != Qnil)
							escapeButtonNumber = NUM2INT(varg7);
					return QMessageBox::information(parent,*caption,*text,
							*button0Textp,*button1Textp,*button2Textp,
							defaultButtonNumber,escapeButtonNumber);
					}
			 }
		}

				      
//    static int warning( QWidget *parent, const QString &caption,
//			const QString& text,
//			int button0, int button1, int button2=0 );

		//RENAME %name(warningButtonText) static int warning( QWidget *parent, const QString &caption,
		//RENAME			const QString& text,
		//RENAME			const QString& button0Text = QString::null,
		//RENAME			const QString& button1Text = QString::null,
		//RENAME			const QString& button2Text = QString::null,
		//RENAME			int defaultButtonNumber = 0,
		//RENAME			int escapeButtonNumber = -1 );
		%extend {
			 static int warning(VALUE varg0, VALUE varg1,
															VALUE varg2, VALUE varg3=Qnil,
															VALUE varg4=Qnil, VALUE varg5=Qnil,			    
															VALUE varg6=Qnil, VALUE varg7=Qnil ) {
			 QWidget* parent;
			 QString* caption;
			 QString* text;
			 parent = (QWidget *)Get_QWidget(varg0);
			 caption = (QString *)Get_QString(varg1);
			 text = (QString *)Get_QString(varg2);
			 if(TYPE(varg3) == T_FIXNUM) {
					int button0;
					int button1=0;
					int button2=0;
					button0 = NUM2INT(varg3);
					if(varg4 != Qnil)
							button1 = NUM2INT(varg4);
					if(varg5 != Qnil)
							button2 = NUM2INT(varg5);
					return QMessageBox::warning(parent,*caption,*text,button0,button1,button2);
			 } else {
					QString button0Text = QString::null;
					QString button1Text = QString::null;
					QString button2Text = QString::null;
					QString *button0Textp, *button1Textp, *button2Textp;
					int defaultButtonNumber = 0;
					int escapeButtonNumber = -1;
					if(varg3 != Qnil) {
							 button0Textp = (QString *)Get_QString(varg3);
					} else {
							button0Textp = &button0Text;
					}
					if(varg4 != Qnil) {
							 button1Textp = (QString *)Get_QString(varg4);
					} else {
							button1Textp = &button1Text;
					}
					if(varg5 != Qnil) {
							 button2Textp = (QString *)Get_QString(varg5);
					} else {
							button2Textp = &button2Text;
					}
					if(varg6 != Qnil) 
							defaultButtonNumber = NUM2INT(varg6);
					if(varg7 != Qnil)
							escapeButtonNumber = NUM2INT(varg7);
					return QMessageBox::warning(parent,*caption,*text,
							*button0Textp,*button1Textp,*button2Textp,
							defaultButtonNumber,escapeButtonNumber);
					}
			 }
		}

//    static int critical( QWidget *parent, const QString &caption,
//			 const QString& text,
//			 int button0, int button1, int button2=0 );

		//RENAME %name(criticalButtonText) static int critical( QWidget *parent, const QString &caption,
		//RENAME			 const QString& text,
		//RENAME			 const QString& button0Text = QString::null,
		//RENAME			 const QString& button1Text = QString::null,
		//RENAME			 const QString& button2Text = QString::null,
		//RENAME			 int defaultButtonNumber = 0,
		//RENAME			 int escapeButtonNumber = -1 );
		%extend {
			 static int critical(VALUE varg0, VALUE varg1,
															VALUE varg2, VALUE varg3=Qnil,
															VALUE varg4=Qnil, VALUE varg5=Qnil,			    
															VALUE varg6=Qnil, VALUE varg7=Qnil ) {
			 QWidget* parent;
			 QString* caption;
			 QString* text;
			 parent = (QWidget *)Get_QWidget(varg0);
			 caption = (QString *)Get_QString(varg1);
			 text = (QString *)Get_QString(varg2);
			 if(TYPE(varg3) == T_FIXNUM) {
					int button0;
					int button1=0;
					int button2=0;
					button0 = NUM2INT(varg3);
					if(varg4 != Qnil)
							button1 = NUM2INT(varg4);
					if(varg5 != Qnil)
							button2 = NUM2INT(varg5);
					return QMessageBox::critical(parent,*caption,*text,button0,button1,button2);
			 } else {
					QString button0Text = QString::null;
					QString button1Text = QString::null;
					QString button2Text = QString::null;
					QString *button0Textp, *button1Textp, *button2Textp;
					int defaultButtonNumber = 0;
					int escapeButtonNumber = -1;
					if(varg3 != Qnil) {
							 button0Textp = (QString *)Get_QString(varg3);
					} else { 
							button0Textp = &button0Text;
					}
					if(varg4 != Qnil) {
							 button1Textp = (QString *)Get_QString(varg4);
					} else {
							button1Textp = &button1Text;
					}
					if(varg5 != Qnil) {
							 button2Textp = (QString *)Get_QString(varg5);
					} else {
							button2Textp = &button2Text;
					}
					if(varg6 != Qnil)
							defaultButtonNumber = NUM2INT(varg6);
					if(varg7 != Qnil)
							escapeButtonNumber = NUM2INT(varg7);
					return QMessageBox::critical(parent,*caption,*text,
							*button0Textp,*button1Textp,*button2Textp,
							defaultButtonNumber,escapeButtonNumber);
					}
			 }
		}


		static void about( QWidget *parent, const QString &caption,
		       const QString& text );

		static void aboutQt( QWidget *parent, const QString& caption=QString::null );
///*
//#if 1 /* OBSOLETE */
 //   static int message( const QString &caption,
//			const QString& text,  const QString& buttonText=QString::null,
//			QWidget *parent=0, const char *name=0 );
//
 //   static bool query( const QString &caption,
//		       const QString& text,  const QString& yesButtonText=QString::null,
////		       const QString& noButtonText=QString::null,
//		       QWidget *parent=0, const char *name=0 );
//#endif
//*/

		QString	text() const;
		void	setText( const QString &qstr);

		Icon	icon() const;
		void	setIcon( Icon );
//    %name(setIconQPixmap) void	setIcon( const QPixmap & );

		const QPixmap *iconPixmap() const;
		void	setIconPixmap( const QPixmap & );

		QString	buttonText( int button ) const;
		void	setButtonText( int button, const QString &);

		void	adjustSize();

		static QPixmap standardIcon( Icon icon, GUIStyle style );

		TextFormat textFormat() const;
		void 	 setTextFormat( TextFormat );
/*
protected:
		void	resizeEvent( QResizeEvent * );
		void	keyPressEvent( QKeyEvent * );
		void	styleChanged( QStyle& );

private slots:
		void	buttonClicked();

private:
		void	init( int, int, int );
		int		indexOf( int ) const;
		void	resizeButtons();
		QLabel     *label;
		QMBData    *mbd;
		void       *reserved1;
		void       *reserved2;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QMessageBox( const QMessageBox & );
		QMessageBox &operator=( const QMessageBox & );
#endif
*/
};


//#endif // QMESSAGEBOX_H
