/****************************************************************************
** $Id: qpixmap.i,v 1.1.1.1 2002/12/22 14:20:11 taka-hr Exp $
**
**
** Definition of QPixmap class
**
** Created : 940501
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QPIXMAP_H
#define QPIXMAP_H

#ifndef QT_H
#include "qpaintdevice.h"
#include "qcolor.h"
#include "qstring.h"
#include "qnamespace.h"
#endif // QT_H


#if defined(_WS_WIN_)
// Internal pixmap memory optimization class for Windows 9x
class QMultiCellPixmap;
#endif


class QPixmap : public QPaintDevice //, public Qt 
{
public:
		enum ColorMode { Auto, Color, Mono };
		enum Optimization { DefaultOptim, NoOptim, MemoryOptim=NoOptim,
			NormalOptim, BestOptim };
	 %extend {
			QPixmap(VALUE varg0 = Qnil, VALUE varg1 = Qnil, VALUE varg2 = Qnil,
							VALUE varg3 = Qnil) {
						 if(varg0 == Qnil) {
								return new QPixmap();
						 }
				 if (TYPE(varg0) == T_NIL) {
							 return new QPixmap();
					}
				 else if (rb_obj_is_kind_of(varg0,cQString) || 
								TYPE(varg0) == T_STRING) {
							 QString* fileName;
							 char* format=0;
							 QPixmap::ColorMode mode=QPixmap::Auto;
							 fileName = (QString *)Get_QString(varg0);
							 if(varg1 != Qnil) format = STR2CSTR(varg1);
							 if(varg2 != Qnil) mode = (QPixmap::ColorMode)NUM2INT(varg2);
							 
							 return new QPixmap(*fileName,format,mode);
					}
				 else if (rb_obj_is_kind_of(varg0,cQSize)) {
							 QSize* qsize;
							 int depth = -1;
							 QPixmap::Optimization optim = QPixmap::DefaultOptim;
							 qsize = (QSize *)Get_QSize(varg0);
							 if(varg1 != Qnil) depth = NUM2INT(varg1);
							 if(varg2 != Qnil) optim = (QPixmap::Optimization)NUM2INT(varg2);
							 return new QPixmap( *qsize,depth,optim );
					}
				 else if (rb_obj_is_kind_of(varg0,cQPixmap)) {
							QPixmap* qpixmap;
							qpixmap = (QPixmap *)Get_QPixmap(varg0);
							return new QPixmap( *qpixmap );
				 }
				 else if (rb_obj_is_kind_of(varg0,cQImage)) {
							QImage* qimage;
							qimage = (QImage *)Get_QImage(varg0);
							QPixmap* qpixmap;
							qpixmap = new QPixmap();
							*qpixmap = *qimage;
							return qpixmap;
				 }

				 else if (TYPE(varg0) == T_ARRAY) {
							int a_size=RARRAY(varg0)->len;
							char** cstr = ALLOC_N(char * ,a_size);
							for(int i=0;i<a_size;i++) {
								 cstr[i] = STR2CSTR(RARRAY(varg0)->ptr[i]);
							}
							//return new QPixmap((const char*[]) cstr );
							return new QPixmap( (const char**) cstr );
				 } else if(rb_obj_is_kind_of(varg0,cQByteArray)) {
							QByteArray *qbary;
							qbary = (QByteArray *)Get_QByteArray(varg0);
							return new QPixmap(*qbary);
				 } else if(TYPE(varg0) == T_FIXNUM && TYPE(varg1) == T_FIXNUM) {
							int w,h;
							int depth = -1;
							QPixmap::Optimization optim = QPixmap::DefaultOptim;
							w = NUM2INT(varg0);
							h = NUM2INT(varg1);
							if(varg2 != Qnil) depth = NUM2INT(varg2);
							if(varg3 != Qnil) optim = (QPixmap::Optimization)NUM2INT(varg3);
							return new QPixmap(w,h,depth,optim);
				 } else {
						rb_raise(rb_eArgError, "ArgError in QPixmap constructor");

					}
			 }
		}

//    QPixmap();
//    QPixmap( int w, int h,  int depth = -1, Optimization = DefaultOptim );
//    QPixmap( const QSize &, int depth = -1, Optimization = DefaultOptim );
//    QPixmap( const QString& fileName, const char *format=0,
//	     ColorMode mode=Auto );
//    QPixmap( const QString& fileName, const char *format,
//	     int conversion_flags );
//    QPixmap( const char *xpm[] );
//    QPixmap( const QByteArray &data );
//    QPixmap( const QPixmap & );
	 ~QPixmap();

//    QPixmap    &operator=( const QPixmap & );
//    QPixmap    &operator=( const QImage	 & );

		bool	isNull()	const;

		int		width()		const { return data->w; }
		int		height()	const { return data->h; }
		QSize	size()		const { return QSize(data->w,data->h); }
		QRect	rect()		const { return QRect(0,0,data->w,data->h); }
		int		depth()		const { return data->d; }
		static int	defaultDepth();

		//RENAME %name(fillQColor) void	fill( const QColor &fillColor = Qt::white );
//    void	fill( const QWidget *, int xofs, int yofs );
		//RENAME %name(fillQPoint) void	fill( const QWidget *, const QPoint &ofs );
//    void	resize( int width, int height );
		//RENAME %name(resizeQSize) void	resize( const QSize & );
		%extend {
			 void fill(VALUE varg0=Qnil,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					if(varg0 == Qnil) {
						 self->fill(Qt::white);
					} else if(rb_obj_is_kind_of(varg0,cQColor)) {
						 QColor* fillColor;
						 fillColor = (QColor *)Get_QColor(varg0);
						 self->fill(*fillColor);
					} else if(rb_obj_is_kind_of(varg0,cQWidget) &&
								TYPE(varg1) == T_FIXNUM &&
								TYPE(varg2) == T_FIXNUM) {
						 QWidget* qw;
						 int xofs,yofs;
						 qw = (QWidget *)Get_QWidget(varg0);
						 xofs = NUM2INT(varg1);
						 yofs = NUM2INT(varg2);
						 self->fill(qw,xofs,yofs);
					} else if(rb_obj_is_kind_of(varg0,cQWidget) && rb_obj_is_kind_of(varg1,cQPoint)) {
						 QWidget* qw;
						 QPoint* ofs;
						 qw = (QWidget *)Get_QWidget(varg0);
						 ofs = (QPoint *)Get_QPoint(varg1);
						 self->fill(qw,*ofs);
					} else {
						 rb_raise(rb_eArgError,"Error in fill() argments");
					}       
			 }
			 void resize(VALUE varg0,VALUE varg1=Qnil) {
					if(varg1 == Qnil) {
						 QSize* qsize;
						 qsize = (QSize *)Get_QSize(varg0);
						 self->resize(*qsize);
					} else {
						 int width,height;
						 width = NUM2INT(varg0);
						 height = NUM2INT(varg1);
						 self->resize(width,height);
					}
			 }
		}

		const QBitmap *mask() const;
		void	setMask( const QBitmap & );
		bool	selfMask() const;
		QBitmap	createHeuristicMask( bool clipTight = TRUE ) const;

		static  QPixmap grabWindow( WId, int x=0, int y=0, int w=-1, int h=-1 );
		static  QPixmap grabWidget( QWidget * widget,
				int x=0, int y=0, int w=-1, int h=-1 );
#ifndef QT_NO_TRANSFORMATIONS
		QPixmap	    xForm( const QWMatrix & ) const;
		static QWMatrix trueMatrix( const QWMatrix &, int w, int h );
#endif

		QImage	convertToImage() const;
		bool	convertFromImage( const QImage &, ColorMode mode=Auto );
		%name(convertFromImageConvFlag) bool convertFromImage( const QImage &, int conversion_flags );
		
		static const char* imageFormat( const QString &fileName );
		bool	load( const QString& fileName, const char *format=0,
		      ColorMode mode=Auto );
		%name(loadConvFlag) bool	load( const QString& fileName, const char *format,
		      int conversion_flags );
		bool	loadFromData( const uchar *buf, uint len,
			      const char* format=0,
			      ColorMode mode=Auto );
		%name(loadFromDataConvFlag) bool	loadFromData( const uchar *buf, uint len,
			      const char* format,
			      int conversion_flags );
		%name(loadFromDataQByteArray) bool	loadFromData( const QByteArray &data,
			      const char* format=0,
			      int conversion_flags=0 );
		bool	save( const QString& fileName, const char* format ) const;

#if defined(_WS_WIN_)
		HBITMAP	hbm()		const;
#endif

		int		serialNumber()	const;

		Optimization	optimization() const;
		void		setOptimization( Optimization );
		static Optimization defaultOptimization();
		static void		setDefaultOptimization( Optimization );

		virtual void detach();

		bool	isQBitmap() const;

#if defined(_WS_WIN_)
		// These functions are internal and used by Windows 9x only
		bool	isMultiCellPixmap() const;
		HDC		multiCellHandle() const;
		HBITMAP	multiCellBitmap() const;
		int		multiCellOffset() const;
		int		allocCell();
		void	freeCell( bool bl = FALSE );
#endif

#if defined(_WS_QWS_)
		virtual QGfx * graphicsContext(bool clip_children=TRUE) const;
		virtual unsigned char * scanLine(int) const;
		virtual int bytesPerLine() const;
		QRgb * clut() const;
		int numCols() const;
#endif

#if defined(Q_FULL_TEMPLATE_INSTANTIATION)
		bool operator==( const QPixmap& ) const { return FALSE; }
#endif

/*
protected:
		QPixmap( int w, int h, const uchar *data, bool isXbitmap );
		int metric( int ) const;

#if defined(_WS_WIN_)

		struct QMCPI {				// mem optim for win9x
	QMultiCellPixmap *mcp;
	int	offset;
		};
#endif

		struct QPixmapData : public QShared {	// internal pixmap data
	QCOORD	w, h;
	short	d;
	uint	uninit	 : 1;
	uint	bitmap	 : 1;
	uint	selfmask : 1;
#if defined(_WS_WIN_)
	uint	mcp	 : 1;
#endif
	int	ser_no;
	QBitmap *mask;
#if defined(_WS_WIN_)
	void   *bits;
	QPixmap *maskpm;
	union {
	    HBITMAP hbm;    // if mcp == FALSE
	    QMCPI  *mcpi;   // if mcp == TRUE
	} hbm_or_mcpi;
#elif defined(_WS_X11_)
	void   *ximage;
	void   *maskgc;
#endif
	Optimization optim;
		} *data;

private:
		QPixmap( int w, int h, int depth, bool, Optimization );
		void	init( int, int, int, bool, Optimization );
		void	deref();
		QPixmap	copy( bool ignoreMask = FALSE ) const;
		static Optimization defOptim;
		friend Q_EXPORT void bitBlt( QPaintDevice *, int, int,
				 const QPaintDevice *,
				 int, int, int, int, RasterOp, bool );
		friend Q_EXPORT void bitBlt( QPaintDevice *, int, int,
				 const QImage* src,
				 int, int, int, int, int conversion_flags );
		friend class QBitmap;
		friend class QPaintDevice;
		friend class QPainter;
*/
};


#endif // QPIXMAP_H
