/****************************************************************************
** $Id: qpushbutton.i,v 1.1.1.1 2002/12/22 14:20:12 taka-hr Exp $
**
** Definition of QPushButton class
**
** Created : 940221
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QPUSHBUTTON_H
//j#define QPUSHBUTTON_H

//#ifndef QT_H
//#include "qbutton.h"
//#include "qiconset.h"
//#endif // QT_H

class QPushButton : public QButton
{
/*
		Q_OBJECT
		
		Q_PROPERTY( bool autoDefault READ autoDefault WRITE setAutoDefault )
		Q_PROPERTY( bool default READ isDefault WRITE setDefault )
		Q_PROPERTY( bool menuButton READ isMenuButton WRITE setIsMenuButton )
		Q_PROPERTY( QIconSet iconSet READ iconSet WRITE setIconSet )
		
		Q_OVERRIDE( bool toggleButton WRITE setToggleButton )
		Q_OVERRIDE( bool on WRITE setOn )
*/
public:
	 %extend {
			QPushButton(VALUE varg0, VALUE varg1=Qnil, VALUE varg2=Qnil,
									VALUE varg3 = Qnil) {
				 if(rb_obj_is_kind_of(varg0,cQWidget ) || TYPE(varg0) == T_NIL) {
						QWidget* parent=0;
						char* name=0;
						if(TYPE(varg0) != T_NIL) parent = (QWidget *)Get_QWidget(varg0);
						if(varg1 != Qnil) name=STR2CSTR(varg1);
						return new QPushButton(parent,name);
				 } else if(TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString )) {
						QWidget* parent=0;
						QString* text;
						char* name=0;
						text = (QString *)Get_QString(varg0);
						if(varg1 != Qnil)
								parent = (QWidget *)Get_QWidget(varg1);
						if(varg2 != Qnil) 
								name=STR2CSTR(varg2);
						return new QPushButton(*text,parent,name);
				 } else if(rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet )|| TYPE(varg0) == T_NIL) {
						if(rb_obj_is_kind_of(varg0,cQPixmap)) {
							 QPixmap* pixmap;
							 QString* text;
							 QWidget* parent;
							 char* name=0;
							 pixmap = (QPixmap *)Get_QPixmap(varg0);
							 text = (QString *)Get_QString(varg1);
							 parent = (QWidget *)Get_QWidget(varg2);
							 if(varg3 != Qnil) name=STR2CSTR(varg3);
							 return new QPushButton(*pixmap,*text,parent,name);
						} else {
							 QIconSet* icons;
							 QString* text;
							 QWidget* parent;
							 char* name=0;
							 icons = (QIconSet *)Get_QIconSet(varg0);
							 text = (QString *)Get_QString(varg1);
							 parent = (QWidget *)Get_QWidget(varg2);
							 if(varg3 != Qnil) name=STR2CSTR(varg3);
							 return new QPushButton(*icons,*text,parent,name);
						}
				 } else {
						rb_raise(rb_eArgError,"Error in QPushButton constructor");
				 }
			}
	 };               
//    QPushButton( QWidget *parent, const char *name=0 );
//    QPushButton( const char * text, QWidget *parent=0, const char* name=0 );
//    QPushButton( const QString &text, QWidget *parent, const char* name=0 );
//    QPushButton( const QIconSet& icon, const QString &text, QWidget *parent, const char* name=0 );
 //   ~QPushButton();

		QSize	sizeHint() const;
		QSizePolicy sizePolicy() const;

//    void	move( int x, int y );
		//RENAME %name(moveQPoint) void	move( const QPoint &p );
		%extend {
			 void move(VALUE varg0, VALUE varg1=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* arg0;
						 arg0 = (QPoint *)Get_QPoint(varg0);
						 self->move(*arg0);
						 return;
					} else {
						 int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->move(x,y);
						 return;
					}
			 }
		} 


//    void	resize( int w, int h );
		//RENAME %name(resizeQSize) void	resize( const QSize & );
		
		%extend {
			 void resize(VALUE varg0, VALUE varg1=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQSize)) {
						 QSize* arg0;
						 arg0 = (QSize *)Get_QSize(varg0);
						 self->resize(*arg0);
						 return;
					} else {
						 int w,h;
						 w = NUM2INT(varg0);
						 h = NUM2INT(varg1);
						 self->resize(w,h);
						 return;
					}
			 } 
	 }
		
//    virtual void setGeometry( int x, int y, int w, int h );

		//RENAME %name(setGeometryQRect) virtual void setGeometry( const QRect & );

		%extend {
			 void setGeometry(VALUE varg0, VALUE varg1=Qnil,
						 VALUE varg2=Qnil, VALUE varg3=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* arg0;
						 arg0 = (QRect *)Get_QRect(varg0);
						 self->setGeometry(*arg0);
						 return;
					} else if(TYPE(varg0) == T_FIXNUM &&
										TYPE(varg1) == T_FIXNUM &&
										TYPE(varg2) == T_FIXNUM &&
										TYPE(varg3) == T_FIXNUM )                    
					{
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->setGeometry(x,y,w,h);
						 return;
					} else {
						 rb_raise(rb_eArgError,"Error in setGeometry argments");
					}
		} 
}


		virtual void setToggleButton( bool ); //### fjern virtual 3.0

		bool	autoDefault()	const	{ return autoDefButton; }
		virtual void setAutoDefault( bool autoDef );
		bool	isDefault()	const	{ return defButton; }
		virtual void setDefault( bool def );

		virtual void setIsMenuButton( bool );
		bool	isMenuButton() const;

		void setPopup( QPopupMenu* popup );
		QPopupMenu* popup() const;

		void setIconSet( const QIconSet& );
		QIconSet* iconSet() const;
		
		void setFlat( bool );
		bool isFlat() const;

//public slots:
		virtual void setOn( bool );

		void	toggle();
/*
protected:
		void	drawButton( QPainter * );
		void	drawButtonLabel( QPainter * );
		void	focusInEvent( QFocusEvent * );
		void	focusOutEvent( QFocusEvent * );
		void	resizeEvent( QResizeEvent * );
		void	updateMask();

private slots:
		void popupPressed();

private:
		void	init();

		uint	autoDefButton	: 1;
		uint	defButton	: 1;
		uint	lastDown		: 1;
		uint	reserved		: 1;
		uint	lastEnabled	: 1;
		uint	hasMenuArrow	: 1;

		friend class QDialog;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QPushButton( const QPushButton & );
		QPushButton &operator=( const QPushButton & );
#endif
*/
};


