/***************************************************************************
										qr2eventfilter.cpp  -  description
													 -------------------
	begin                : Sat Aug 18 13:58:51 JST 2001
	copyright            : (C) 2001 by Nobuyuki Horie
	email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * $Id: qr2eventfilter.cpp,v 1.1.1.1 2002/12/22 14:20:12 taka-hr Exp $
 * Purpose: 
 * Author:  
 */

#include "swig_class_qte.h"
#include "qr2eventfilter.h"
#include "qrbfunction.h"

//#include "qt2_wrap.h"

QR2EventFilter::QR2EventFilter(VALUE ruby_obj):
	rubyobj(ruby_obj)
{
}
QR2EventFilter::~QR2EventFilter()
{
	 //    debug("QREventFilter destructed.");
}

/**
*/
bool QR2EventFilter::eventFilter(QObject* object, QEvent* event)
{
//	This makes stack overflow.
//      if(ruby_respondTo(rubyobj,"event")) {
//          rb_funcall(rubyobj,rb_intern("event"),1,Wrap_QEvent(cQEvent,event));
//     }
//debug("EventFilter called:%d",event->type());
	 switch( event->type() ) {
			case QEvent::None:    //not an event 
			break;
			case QEvent::Timer:   //regular timer events 
				 if (ruby_respondTo(rubyobj,"timerEvent") ) {
					 rb_funcall(rubyobj,rb_intern("timerEvent"),1,Wrap_QTimerEvent(cQTimerEvent,event));
					 }
			break;
			case QEvent::MouseButtonPress:  //mouse press
			if (ruby_respondTo(rubyobj,"mousePressEvent")) {
					 rb_funcall(rubyobj,rb_intern("mousePressEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsMousePressEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsMousePressEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportMousePressEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportMousePressEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			break;
			case QEvent::MouseButtonRelease:  //mouse release
			if (ruby_respondTo(rubyobj,"mouseReleaseEvent")) {
					 rb_funcall(rubyobj,rb_intern("mouseReleaseEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsMouseReleaseEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsMouseReleaseEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportMouseReleaseEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportMouseReleaseEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			break;
			
			case QEvent::MouseButtonDblClick:  //mouse double click
			if (ruby_respondTo(rubyobj,"mouseDoubleClickEvent")) {
					 rb_funcall(rubyobj,rb_intern("mouseDoubleClickEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsMouseDoubleClickEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsMouseDoubleClickEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportMouseDoubleClickEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportMouseDoubleClickEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			break;
			case QEvent::MouseMove:  //mouse move
			if (ruby_respondTo(rubyobj,"mouseMoveEvent")) {
					 rb_funcall(rubyobj,rb_intern("mouseMoveEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsMouseMoveEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsMouseMoveEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportMouseMoveEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportMouseMoveEvent"),1,Wrap_QMouseEvent(cQMouseEvent,event));
					 }
			break;
			case QEvent::KeyPress:  // key pressed
					{
			if (ruby_respondTo(rubyobj,"keyPressEvent")) {
					 VALUE vevent = Wrap_QKeyEvent(cQKeyEvent,event);
					 rb_funcall(rubyobj,rb_intern("keyPressEvent"),1,vevent);
			if (rb_funcall(vevent,rb_intern("isAccepted"),0) == Qtrue) {
						((QKeyEvent *)event)->accept();
					} else {
						((QKeyEvent *)event)->ignore();
						return true;}
					}
				}
			break;
			case QEvent::KeyRelease: // key released
			if (ruby_respondTo(rubyobj,"keyReleaseEvent")) {
					VALUE vevent = Wrap_QKeyEvent(cQKeyEvent,event);
					rb_funcall(rubyobj,rb_intern("keyReleaseEvent"),1,vevent);
				 }
			break;  
			case QEvent::FocusIn:  // keyboard focus received
			if (ruby_respondTo(rubyobj,"focusInEvent")) {
					rb_funcall(rubyobj,rb_intern("focusInEvent"),1,Wrap_QFocusEvent(cQFocusEvent,event));
				 }
			break;
			case QEvent::FocusOut:   // keyboard focus lost
			if (ruby_respondTo(rubyobj,"focusOutEvent")) {
				 rb_funcall(rubyobj,rb_intern("focusOutEvent"),1,Wrap_QFocusEvent(cQFocusEvent,event));
				 }
			break;
			case QEvent::Enter:  // mouse enters widget
			if (ruby_respondTo(rubyobj,"enterEvent")) {
					 rb_funcall(rubyobj,rb_intern("enterEvent"),1,Wrap_QEvent(cQEvent,event));
					 }
			break;
			case QEvent::Leave:   // mouse leaves widget
			if (ruby_respondTo(rubyobj,"leaveEvent")) {
					 rb_funcall(rubyobj,rb_intern("leaveEvent"),1,Wrap_QEvent(cQEvent,event));
					 }
			break;
			case QEvent::Paint: // paint widget
			if (ruby_respondTo(rubyobj,"paintEvent")) {
					 rb_funcall(rubyobj,rb_intern("paintEvent"),1,Wrap_QPaintEvent(cQPaintEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportPaintEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportPaintEvent"),1,Wrap_QPaintEvent(cQPaintEvent,event));
					 }
			break;
			case QEvent::Move: // move widget
			if (ruby_respondTo(rubyobj,"moveEvent")) {
					 rb_funcall(rubyobj,rb_intern("moveEvent"),1,Wrap_QMoveEvent(cQMoveEvent,event));
					 }      
			break;
			case QEvent::Resize: //resize widget
			if (ruby_respondTo(rubyobj,"resizeEvent")) {
					 rb_funcall(rubyobj,rb_intern("resizeEvent"),1,Wrap_QResizeEvent(cQResizeEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportResizeEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportResizeEvent"),1,Wrap_QPaintEvent(cQPaintEvent,event));
					 }      
			break;
			case QEvent::Create: // after object creation
			if (ruby_respondTo(rubyobj,"createEvent")) {
					 rb_funcall(rubyobj,rb_intern("createEvent"),1,Wrap_QEvent(cQEvent,event));
					 }      
			break;
			case QEvent::Destroy: // during object destruction
			if (ruby_respondTo(rubyobj,"destroyEvent")) {
					 rb_funcall(rubyobj,rb_intern("destroyEvent"),1,Wrap_QEvent(cQEvent,event));
					 }      
			break;
			case QEvent::Show: //widget is shown
			if (ruby_respondTo(rubyobj,"showEvent")) {
					 rb_funcall(rubyobj,rb_intern("showEvent"),1,Wrap_QShowEvent(cQShowEvent,event));
					 }      
			break;
			case QEvent::Hide: // widget is hidden
			if (ruby_respondTo(rubyobj,"hideEvent")) {
					 rb_funcall(rubyobj,rb_intern("hideEvent"),1,Wrap_QHideEvent(cQHideEvent,event));
					 }      
			break;
			case QEvent::Close: // request to close widget
				{
				if (ruby_respondTo(rubyobj,"closeEvent")) {
					 VALUE vevent = Wrap_QCloseEvent(cQCloseEvent,event); 
					 rb_funcall(rubyobj,rb_intern("closeEvent"),1,vevent);
				if (rb_funcall(vevent,rb_intern("isAccepted"),0) == Qtrue) {
						((QCloseEvent *)event)->accept();
			 } else {
						((QCloseEvent *)event)->ignore();
						return true;}
					 }
				}      
			break;
			case QEvent::Quit: // request to quit application
			if (ruby_respondTo(rubyobj,"quitEvent")) {
					 rb_funcall(rubyobj,rb_intern("quitEvent"),1,Wrap_QEvent(cQEvent,event));
					 }      
			break;
			case QEvent::Reparent: // widget has been reparented
			if (ruby_respondTo(rubyobj,"reparentEvent")) {
					 rb_funcall(rubyobj,rb_intern("reparentEvent"),1,Wrap_QEvent(cQEvent,event));
					 }            
			break;
			case QEvent::ShowMinimized: // widget is shown minimized
			if (ruby_respondTo(rubyobj,"showMinimizedEvent")) {
					 rb_funcall(rubyobj,rb_intern("showMinimizedEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                  
			break;
			case QEvent::ShowNormal: // widget is shown normal
			if (ruby_respondTo(rubyobj,"showNormalEvent")) {
					 rb_funcall(rubyobj,rb_intern("showNormalEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                  
			break;
			case QEvent::WindowActivate: // widget was acivated
			if (ruby_respondTo(rubyobj,"windowActivateEvent")) {
					 rb_funcall(rubyobj,rb_intern("windowActivateEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                  
			break;
			case QEvent::WindowDeactivate: //window was deactivated
			if (ruby_respondTo(rubyobj,"windowDeactivateEvent")) {
					 rb_funcall(rubyobj,rb_intern("windowDeactivateEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                  
			break;
			case QEvent::ShowToParent: // widget is hown to parent
			if (ruby_respondTo(rubyobj,"showToParentEvent")) {
					 rb_funcall(rubyobj,rb_intern("showToParentEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                  
			break;
			case QEvent::HideToParent: // widget is hiddento parent
			if (ruby_respondTo(rubyobj,"hideToParentEvent")) {
					 rb_funcall(rubyobj,rb_intern("hideToParentEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                  
			break;
			case QEvent::ShowMaximized: // widget is shown maximized
			if (ruby_respondTo(rubyobj,"showMaximizedEvent")) {
					 rb_funcall(rubyobj,rb_intern("showMaximizedEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                  
			break;
			case QEvent::Accel: // accelaerator event
			if (ruby_respondTo(rubyobj,"accelEvent")) {
					 rb_funcall(rubyobj,rb_intern("accelEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                 
			break;
			case QEvent::Wheel: // wheel event
			if (ruby_respondTo(rubyobj,"wheelEvent")) {
					 rb_funcall(rubyobj,rb_intern("wheelEvent"),1,Wrap_QWheelEvent(cQWheelEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsWheelEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsWheelEvent"),1,Wrap_QWheelEvent(cQWheelEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportWheelEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportWheelEvent"),1,Wrap_QWheelEvent(cQWheelEvent,event));
					 }      
			break;
			case QEvent::AccelAvailable: // accelerator available event
			if (ruby_respondTo(rubyobj,"accelAvailableEvent")) {
					 rb_funcall(rubyobj,rb_intern("accelAvailableEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                       
			break;
			case QEvent::CaptionChange: // caption changed
			if (ruby_respondTo(rubyobj,"captionChangeEvent")) {
					 rb_funcall(rubyobj,rb_intern("captionChangeEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                       
			break;
			case QEvent::IconChange: // icon changed
			if (ruby_respondTo(rubyobj,"iconChangeEvent")) {
					 rb_funcall(rubyobj,rb_intern("iconChangeEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                       
			break;
			case QEvent::ParentFontChange: // parent font changed
			if (ruby_respondTo(rubyobj,"parentFontEvent")) {
					 rb_funcall(rubyobj,rb_intern("parentFontEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                       
			break;
			case QEvent::ApplicationFontChange: // application font changed
			if (ruby_respondTo(rubyobj,"applicationFontEvent")) {
					 rb_funcall(rubyobj,rb_intern("applicationFontEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                       
			break;
			case QEvent::ParentPaletteChange: // parent font changed
			if (ruby_respondTo(rubyobj,"parentPaletteEvent")) {
					 rb_funcall(rubyobj,rb_intern("parentPaletteEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                       
			break;
			case QEvent::ApplicationPaletteChange: // application palette changed
			if (ruby_respondTo(rubyobj,"applicationPaletteEvent")) {
					 rb_funcall(rubyobj,rb_intern("applicationPaletteEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                       
			break;
			case QEvent::Clipboard: // internal clipboard event
				if (ruby_respondTo(rubyobj,"clipboardEvent")) {
					 rb_funcall(rubyobj,rb_intern("clipboardEvent"),1,Wrap_QEvent(cQEvent,event));
					 }      
			break;
			case QEvent::Speech: // reserved for speech input
				if (ruby_respondTo(rubyobj,"speechEvent")) {
					 rb_funcall(rubyobj,rb_intern("speechEvent"),1,Wrap_QEvent(cQEvent,event));
					 }      
			break;
			case QEvent::SockAct: // socket activation
				if (ruby_respondTo(rubyobj,"sockActEvent")) {
					 rb_funcall(rubyobj,rb_intern("sockActEvent"),1,Wrap_QEvent(cQEvent,event));
					 }      
			break;
			case QEvent::AccelOverride: // accelerator override event
				if (ruby_respondTo(rubyobj,"accelOverrideEvent")) {
					 rb_funcall(rubyobj,rb_intern("accelOverrideEvent"),1,Wrap_QEvent(cQEvent,event));
					 }      
			break;
#ifndef QT_NO_DRAGANDDROP
			case QEvent::DragEnter: // drag moves into widget
			if (ruby_respondTo(rubyobj,"dragEnterEvent")) {
					 rb_funcall(rubyobj,rb_intern("dragEnterEvent"),1,Wrap_QDragEnterEvent(cQDragEnterEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsDragEnterEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsDragEnterEvent"),1,Wrap_QDragEnterEvent(cQDragEnterEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportDragEnterEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportDragEnterEvent"),1,Wrap_QDragEnterEvent(cQDragEnterEvent,event));
					 }            
			break;
			case QEvent::DragMove: // drag moves in widget
			if (ruby_respondTo(rubyobj,"dragMoveEvent")) {
					 rb_funcall(rubyobj,rb_intern("dragMoveEvent"),1,Wrap_QDragMoveEvent(cQDragMoveEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsDragMoveEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsDragMoveEvent"),1,Wrap_QDragMoveEvent(cQDragMoveEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportDragMoveEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportDragMoveEvent"),1,Wrap_QDragMoveEvent(cQDragMoveEvent,event));
					 }                  
			break;
			case QEvent::DragLeave: // dgrag leaves or is cancelled
			if (ruby_respondTo(rubyobj,"dragLeaveEvent")) {
					 rb_funcall(rubyobj,rb_intern("dragLeaveEvent"),1,Wrap_QDragLeaveEvent(cQDragLeaveEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsDragLeaveEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsDragLeaveEvent"),1,Wrap_QDragLeaveEvent(cQDragLeaveEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportDragLeaveEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportDragLeaveEvent"),1,Wrap_QDragLeaveEvent(cQDragLeaveEvent,event));
					 }                        
			break;
			case QEvent::Drop: // actual drop
			if (ruby_respondTo(rubyobj,"dropEvent")) {
					 rb_funcall(rubyobj,rb_intern("dropEvent"),1,Wrap_QDropEvent(cQDropEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"contentsDropEvent")) {
					 rb_funcall(rubyobj,rb_intern("contentsDropEvent"),1,Wrap_QDropEvent(cQDropEvent,event));
					 }
			if (ruby_respondTo(rubyobj,"viewportDropEvent")) {
					 rb_funcall(rubyobj,rb_intern("viewportDropEvent"),1,Wrap_QDropEvent(cQDropEvent,event));
					 }                        
			break;
			case QEvent::DragResponse: // drag accepted/rejected
			if (ruby_respondTo(rubyobj,"dragResponseEvent")) {
					 rb_funcall(rubyobj,rb_intern("dragResponseEvent"),1,Wrap_QDragResponseEvent(cQDragResponseEvent,event));
					 }    
			break;
#endif
			case QEvent::ChildInserted: // new child widget
			if (ruby_respondTo(rubyobj,"childEvent")) {
					 rb_funcall(rubyobj,rb_intern("childEvent"),1,Wrap_QChildEvent(cQChildEvent,event));
					 }      
			break;
			case QEvent::ChildRemoved: // deleted child widget
			if (ruby_respondTo(rubyobj,"childEvent")) {
					 rb_funcall(rubyobj,rb_intern("childEvent"),1,Wrap_QChildEvent(cQChildEvent,event));
					 }            
			break;
			case QEvent::LayoutHint: // child min/max size changed
				if (ruby_respondTo(rubyobj,"layoutHintEvent")) {
					 rb_funcall(rubyobj,rb_intern("layoutHintEvent"),1,Wrap_QEvent(cQEvent,event));
					 }            
			break;
			case QEvent::ShowWindowRequest: // widget's window should be mapped
				if (ruby_respondTo(rubyobj,"showWindowRequestEvent")) {
					 rb_funcall(rubyobj,rb_intern("showWindowRequestEvent"),1,Wrap_QEvent(cQEvent,event));
					 }            
			break;
			case QEvent::ActivateControl: // ActiveX activation
				if (ruby_respondTo(rubyobj,"activateControlEvent")) {
					 rb_funcall(rubyobj,rb_intern("activateControlEvent"),1,Wrap_QEvent(cQEvent,event));
					 }            
			break;
			case QEvent::DeactivateControl: // activeX deactivation
				if (ruby_respondTo(rubyobj,"deactivateControlEvent")) {
					 rb_funcall(rubyobj,rb_intern("deactivateControlEvent"),1,Wrap_QEvent(cQEvent,event));
					 }                  
			break;
			//case User // first user event id
			default:
			break;
	}
	 
	return false;   
}
