/***************************************************************************
                    qrobject.h  -  description
                           -------------------
  begin                : Sat Aug 18 13:58:52 JST 2001
  copyright            : (C) 2001 by Nobuyuki Horie
  email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * $Id: qrobject.h,v 1.1.1.1 2002/12/22 14:20:13 taka-hr Exp $
 * Purpose: For ruby/Qt wrapping ruby object in C++
 * Author:  N. Horie
 */

#ifndef _QRObject_h
#define _QRObject_h
#include <ruby.h>
#ifdef NT
  #include "canceldefs.h"
#endif
#include <qobject.h>
#include <qlist.h>
//#include <q1xcompatibility.h>

//#include "qrmovie.h"
#include "rslot.h"
#include "rslotqiconviewitem.h"
#include "rsignal.h"

class QRObject : public QObject
/**
*/
	{
//        Q_OBJECT
	private:
	QRObject();
	static
	RSlot* make_rslot(const char* arg_type, VALUE robj, char* rmember);
        static
        RSlot* make_rslot(const char* qtsignal,int menuId, VALUE robj, char* rmember);

	static QRObject* _instance;
	protected:
	//QRObject();	
        static QList<RSlot>* RSlots; 
	public:
	static 
	void QRObj_init();
	virtual ~QRObject();
	static void callback_ruby(VALUE ruby_object, const char* ruby_method);
	static
	RSlot& connect_rslot(const QObject* qt_object, const char* qt_signal,
		VALUE ruby_object, char* ruby_method);
        static
        RSlot& connect_rslot_menuId(const QObject* qt_object, const char* qt_signal,int menuId,
		VALUE ruby_object, char* ruby_method);

	static
	RSignal& connect_rsignal(RSignal& ruby_signal,
	const QObject* qt_object, const char* qt_slot);
	
	static
	RSignal& connect_rsignalslot(RSignal& ruby_signal,
	VALUE ruby_object, char* ruby_mentod);
	
	static
	RSignal& connect_rsignalrsignal(RSignal& ruby_signal1,
	RSignal& ruby_signal2);
	
	static
	void connect_qsignalrsignal(const QObject* qt_object,
	const char* qt_signal,RSignal& ruby_signal);

	static
	bool connectItem_rslot (QAccel* accel, int id, 
	VALUE receiver, char * member );  

        static
        bool connectItem_rsignal (QAccel* accel, int id, RSignal& ruby_signal );

	static
	bool disconnectItem_rslot (QAccel* accel, int id,
	RSlotVoid& ruby_slot ); 

        static
        bool disconnectItem_rsignal (QAccel* accel, int id, RSignal& ruby_signal );


friend class QRMovie;
friend class RSignal;


        };
	
#endif

