/****************************************************************************
** $Id: qscrollview.i,v 1.1.1.1 2002/12/22 14:20:14 taka-hr Exp $
**
** Definition of QScrollView class
**
** Created : 970523
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/
//#ifndef QSCROLLVIEW_H
//#define QSCROLLVIEW_H

//#ifndef QT_H
//#include "qframe.h"
//#include "qscrollbar.h"
//#endif // QT_H

struct QScrollViewData;

class QScrollView : public QFrame
{
/*
		Q_OBJECT
		Q_ENUMS( ResizePolicy ScrollBarMode )
		Q_PROPERTY( ResizePolicy resizePolicy READ resizePolicy WRITE setResizePolicy )
		Q_PROPERTY( ScrollBarMode vScrollBarMode READ vScrollBarMode WRITE setVScrollBarMode )
		Q_PROPERTY( ScrollBarMode hScrollBarMode READ hScrollBarMode WRITE setHScrollBarMode )
		Q_PROPERTY( int visibleWidth READ visibleWidth )
		Q_PROPERTY( int visibleHeight READ visibleHeight )
		Q_PROPERTY( int contentsWidth READ contentsWidth )
		Q_PROPERTY( int contentsHeight READ contentsHeight )
		Q_PROPERTY( int contentsX READ contentsX )
		Q_PROPERTY( int contentsY READ contentsY )
		Q_PROPERTY( bool dragAutoScroll READ dragAutoScroll WRITE setDragAutoScroll )
*/
public:
		QScrollView(QWidget *parent=0, const char *name=0, WFlags f=0);
//    ~QScrollView();

		enum ResizePolicy { Default, Manual, AutoOne };
		virtual void setResizePolicy( ResizePolicy );
		ResizePolicy resizePolicy() const;

		void styleChange(QStyle&);
//    void removeChild(QWidget* child);
		virtual void addChild( QWidget* child, int x=0, int y=0 );
		virtual void moveChild( QWidget* child, int x, int y );
		int childX(QWidget* child);
		int childY(QWidget* child);
		bool childIsVisible(QWidget* child);
		void showChild(QWidget* child, bool yes=TRUE);

		enum ScrollBarMode { Auto, AlwaysOff, AlwaysOn };

		ScrollBarMode vScrollBarMode() const;
		virtual void  setVScrollBarMode( ScrollBarMode );

		ScrollBarMode hScrollBarMode() const;
		virtual void  setHScrollBarMode( ScrollBarMode );

		QWidget*     cornerWidget() const;
		virtual void setCornerWidget(QWidget*);

		QScrollBar*  horizontalScrollBar() const;
		QScrollBar*  verticalScrollBar() const;
		QWidget*	 viewport() const;
		QWidget*	 clipper() const;

		int		visibleWidth() const;
		int		visibleHeight() const;

		int		contentsWidth() const;
		int		contentsHeight() const;
		int		contentsX() const;
		int		contentsY() const;

//    void	resize( int w, int h );
		//RENAME %name(resizeQSize) void	resize( const QSize& );
		%extend {
			 void resize(VALUE varg0, VALUE varg1=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQSize)) {
						 QSize* arg0;
						 arg0 = (QSize *)Get_QSize(varg0);
						 self->resize(*arg0);
						 return;
					} else {
						 int w,h;
						 w = NUM2INT(varg0);
						 h = NUM2INT(varg1);
						 self->resize(w,h);
						 return;
					}
			 } 
	 }    
		
		void	show();


//    void	updateContents( int x, int y, int w, int h );
		//RENAME %name(updateContentsQRect) void	updateContents( const QRect& r );
		%extend {
			 void updateContents(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* r;
						 r = (QRect *)Get_QRect(varg0);
						 self->updateContents(*r);
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->updateContents(x,y,w,h);
					}
			 }
		}
							
		
//    void	repaintContents( int x, int y, int w, int h, bool erase=TRUE );
		//RENAME %name(repaintContentsQRect) void	repaintContents( const QRect& r, bool erase=TRUE );
		%extend {
			 void repaintContents(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil,
														VALUE varg4=Qnil) {
					bool erase=TRUE;
					if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* r;
						 r = (QRect *)Get_QRect(varg0);
						 if(varg1 != Qnil) 
								 erase = (varg1 == Qtrue) ? TRUE:FALSE;
						 self->repaintContents(*r,erase);
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 if(varg4 != Qnil) 
								 erase = (varg4 == Qtrue) ? TRUE:FALSE;             
						 self->repaintContents(x,y,w,h,erase);
					}
			 }
		}


//### make this const in 3.0
//    void	contentsToViewport(int x, int y, int& vx, int& vy);
//### make this const in 3.0
//    void	viewportToContents(int vx, int vy, int& x, int& y);
		//RENAME %name(contentsToViewportQPoint) QPoint	contentsToViewport(const QPoint&);
		//RENAME %name(viewportToContentsQPoint) QPoint	viewportToContents(const QPoint&);
		%extend {
			 VALUE viewportToContents(VALUE varg0,VALUE varg1=Qnil,
							VALUE varg2=Qnil, VALUE varg3=Qnil) {
					VALUE vresult;
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* qp;
						 QPoint* result;
						 qp = (QPoint *)Get_QPoint(varg0);
						 result = new QPoint(self->viewportToContents(*qp));
						 CHECK_PTR(result);
						 vresult = Wrap_QPoint(cQPoint,result);
						 return vresult;
					} else {
						 int x,y;
						 int vx,vy;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->viewportToContents(x,y,vx,vy);
						 output_helper(vresult,INT2NUM(vx));
						 output_helper(vresult,INT2NUM(vy));
						 return vresult;
					}
			 }
			 VALUE contentsToViewport(VALUE varg0,VALUE varg1=Qnil,
							VALUE varg2=Qnil, VALUE varg3=Qnil) {
					VALUE vresult;
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* qp;
						 QPoint* result;
						 qp = (QPoint *)Get_QPoint(varg0);
						 result = new QPoint(self->contentsToViewport(*qp));
						 CHECK_PTR(result);
						 vresult = Wrap_QPoint(cQPoint,result);
						 return vresult;
					} else {
						 int x,y;
						 int vx,vy;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->contentsToViewport(x,y,vx,vy);
						 output_helper(vresult,INT2NUM(vx));
						 output_helper(vresult,INT2NUM(vy));
						 return vresult;
					}
			 }
		}
		
						 

		void	enableClipper(bool y);

		QSize	viewportSize( int, int ) const;
		QSizePolicy sizePolicy() const;
		QSize	sizeHint() const;
		QSize	minimumSizeHint() const;

		//RENAME %name(removeChildQObject) void	removeChild(QObject* child);
		%extend {
			 void removeChild(VALUE varg0) {
					if(rb_obj_is_kind_of(varg0,cQWidget)) {
						 QWidget* wd;
						 wd = (QWidget *)Get_QWidget(varg0);
						 self->removeChild(wd);
					} else {
						 QObject* qo;
						 qo = (QObject *)Get_QObject(varg0);
						 self->removeChild(qo);
					}
			 }
		}

#ifndef QT_NO_DRAGANDDROP
		void	setDragAutoScroll( bool b ); // #### virtual in 3.0
		bool	dragAutoScroll() const;
#endif
/*
signals:
		void	contentsMoving(int x, int y);
*/
//public slots:
		virtual void resizeContents( int w, int h );
		void	scrollBy( int dx, int dy );
		virtual void        setContentsPos( int x, int y );
//    void	ensureVisible(int x, int y);
		//RENAME %name(ensureVisibleMargin) void	ensureVisible(int x, int y, int xmargin, int ymargin);
//    void	center(int x, int y);
		//RENAME %name(centerMargin) void	center(int x, int y, float xmargin, float ymargin);
		%extend {
			 void ensureVisible(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
					if(varg3 == Qnil) {
						 self->ensureVisible(x,y);
					} else {
						 int xm,ym;
						 xm = NUM2INT(varg2);
						 ym = NUM2INT(varg3);
						 self->ensureVisible(x,y,xm,ym);
					}
			 }
			 void center(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
					if(varg3 == Qnil) {
						 self->center(x,y);
					} else {
						 float xm,ym;
						 xm = NUM2DBL(varg2);
						 ym = NUM2DBL(varg3);
						 self->center(x,y,xm,ym);
					}
			 }
		}

						 


		void	updateScrollBars();
		void	setEnabled( bool enable );
/*
protected:
		void	resizeEvent(QResizeEvent*);
		void 	wheelEvent( QWheelEvent * );
		bool	eventFilter( QObject *, QEvent *e );

		virtual void contentsMousePressEvent( QMouseEvent* );
		virtual void contentsMouseReleaseEvent( QMouseEvent* );
		virtual void contentsMouseDoubleClickEvent( QMouseEvent* );
		virtual void contentsMouseMoveEvent( QMouseEvent* );
#ifndef QT_NO_DRAGANDDROP
		virtual void contentsDragEnterEvent( QDragEnterEvent * );
		virtual void contentsDragMoveEvent( QDragMoveEvent * );
		virtual void contentsDragLeaveEvent( QDragLeaveEvent * );
		virtual void contentsDropEvent( QDropEvent * );
#endif
		virtual void contentsWheelEvent( QWheelEvent * );

		virtual void viewportPaintEvent( QPaintEvent* );
		virtual void viewportResizeEvent( QResizeEvent* );
		virtual void viewportMousePressEvent( QMouseEvent* );
		virtual void viewportMouseReleaseEvent( QMouseEvent* );
		virtual void viewportMouseDoubleClickEvent( QMouseEvent* );
		virtual void viewportMouseMoveEvent( QMouseEvent* );
#ifndef QT_NO_DRAGANDDROP
		virtual void viewportDragEnterEvent( QDragEnterEvent * );
		virtual void viewportDragMoveEvent( QDragMoveEvent * );
		virtual void viewportDragLeaveEvent( QDragLeaveEvent * );
		virtual void viewportDropEvent( QDropEvent * );
#endif
		virtual void viewportWheelEvent( QWheelEvent * );

		virtual void drawContentsOffset(QPainter*, int ox, int oy,
		    int cx, int cy, int cw, int ch);
		virtual void drawContents(QPainter*, int cx, int cy, int cw, int ch);
		void	frameChanged();

		virtual void setMargins(int left, int top, int right, int bottom);
		int leftMargin() const;
		int topMargin() const;
		int rightMargin() const;
		int bottomMargin() const;

		bool focusNextPrevChild( bool next );

		virtual void setHBarGeometry(QScrollBar& hbar, int x, int y, int w, int h);
		virtual void setVBarGeometry(QScrollBar& vbar, int x, int y, int w, int h);

private:
		virtual void drawContents( QPainter* );
		void moveContents(int x, int y);

		QScrollViewData* d;

private slots:
		void hslide(int);
		void vslide(int);
#ifndef QT_NO_DRAGANDDROP
		void doDragAutoScroll();
		void startDragAutoScroll();
		void stopDragAutoScroll();
#endif

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QScrollView( const QScrollView & );
		QScrollView &operator=( const QScrollView & );
#endif
		void changeFrameRect(const QRect&);
*/
};

//#endif
