/****************************************************************************
** $Id: qspinbox.i,v 1.1.1.1 2002/12/22 14:20:14 taka-hr Exp $
**
** Definition of QSpinBox widget class
**
** Created : 1997
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

//#ifndef QSPINBOX_H
//#define QSPINBOX_H

//#ifndef QT_H
//#include "qframe.h"
//#include "qrangecontrol.h"
//#endif // QT_H

//#ifndef QT_NO_SPINBOX


class QPushButton;
class QLineEdit;
class QValidator;

struct QSpinBoxPrivate;

class QSpinBox: public QFrame, public QRangeControl
{
/*
		Q_OBJECT
		Q_ENUMS( ButtonSymbols )
		Q_PROPERTY( QString text READ text )
		Q_PROPERTY( QString prefix READ prefix WRITE setPrefix )
		Q_PROPERTY( QString suffix READ suffix WRITE setSuffix )
		Q_PROPERTY( QString cleanText READ cleanText )
		Q_PROPERTY( QString specialValueText READ specialValueText WRITE setSpecialValueText )
		Q_PROPERTY( bool wrapping READ wrapping WRITE setWrapping )
		Q_PROPERTY( ButtonSymbols buttonSymbols READ buttonSymbols WRITE setButtonSymbols )
		Q_PROPERTY( int minValue READ minValue WRITE setMinValue )
		Q_PROPERTY( int maxValue READ maxValue WRITE setMaxValue )
		Q_PROPERTY( int lineStep READ lineStep WRITE setLineStep )
		Q_PROPERTY( int value READ value WRITE setValue )
*/	
public:
	 %extend{
			QSpinBox(VALUE varg0=Qnil, VALUE varg1=Qnil, VALUE varg2=Qnil,
							 VALUE varg3=Qnil, VALUE varg4=Qnil) {
				 if(varg0 == Qnil) {
						return new QSpinBox();
				 } else if(TYPE(varg0) == T_FIXNUM) {
						int minValue(NUM2INT(varg0));
						int maxValue(NUM2INT(varg1));
						int step = 1;
						QWidget* parent=0;
						char* name=0;
						if(varg2 != Qnil) step = NUM2INT(varg2);
						if(varg3 != Qnil) parent = (QWidget *)Get_QWidget(varg3);
						if(varg4 != Qnil) name = STR2CSTR(varg4);
						return new QSpinBox(minValue,maxValue,step, parent,name);
				 } else if(rb_obj_is_kind_of(varg0,cQWidget) || TYPE(varg0) == T_NIL) {
						QWidget* parent;
						char* name=0;
						parent = (QWidget *)Get_QWidget(varg0);
						if(varg1 != Qnil) name = STR2CSTR(varg1);
						return new QSpinBox(parent,name);
				 } else {
						rb_raise(rb_eArgError,"Type Error in QSpinBox constructor");
				 }
			}
	 };
//    QSpinBox( QWidget* parent = 0, const char *name = 0 );
//    QSpinBox( int minValue, int maxValue, int step = 1,
//	      QWidget* parent = 0, const char* name = 0 );
//    ~QSpinBox();

		QString 		text() const;

		virtual QString 	prefix() const;
		virtual QString 	suffix() const;
		virtual QString 	cleanText() const;

		virtual void	setSpecialValueText( const QString &text );
		QString 		specialValueText() const;

		virtual void 	setWrapping( bool on );
		bool 		wrapping() const;

		enum ButtonSymbols { UpDownArrows, PlusMinus };
		void		setButtonSymbols( ButtonSymbols ); // 3.0: virtual
		ButtonSymbols	buttonSymbols() const;

		virtual void	setValidator( const QValidator* v );
		const QValidator * validator() const;

		QSize 		sizeHint() const;
		QSizePolicy 	sizePolicy() const;

		int	 minValue() const;
		int	 maxValue() const;
		void setMinValue( int );
		void setMaxValue( int );
		int	 lineStep() const;
		void setLineStep( int );
		int  value() const;

public: // slots:
		virtual void	setValue( int value );
		virtual void	setPrefix( const QString &text );
		virtual void	setSuffix( const QString &text );
		virtual void	stepUp();
		virtual void	stepDown();
		virtual void	setEnabled( bool );
// QRangeControl methods
//    int		value()		const;
//    void	setValue( int );
		void	addPage();
		void	subtractPage();
		void	addLine();
		void	subtractLine();

//    int		minValue()	const;
//    int		maxValue()	const;
		void	setRange( int minValue, int maxValue );

//    int		lineStep()	const;
		int		pageStep()	const;
		void	setSteps( int line, int page );

		int		bound( int ) const;
/*
signals:
		void		valueChanged( int value );
		void		valueChanged( const QString &valueText );

protected:
		virtual QString	mapValueToText( int value );
		virtual int		mapTextToValue( bool* ok );
		QString		currentValueText();

		virtual void	updateDisplay();
		virtual void	interpretText();

		QPushButton*	upButton() const;
		QPushButton*	downButton() const;
		QLineEdit*		editor() const;

		virtual void	valueChange();
		virtual void	rangeChange();

		bool		eventFilter( QObject* obj, QEvent* ev );
		void		resizeEvent( QResizeEvent* ev );
		void		wheelEvent( QWheelEvent * );
		void		leaveEvent( QEvent* );

		void		styleChange( QStyle& );

protected slots:
		void		textChanged();

private:
		void initSpinBox();
		struct QSpinBoxPrivate* d;
		QPushButton* up;
		QPushButton* down;
		QLineEdit* vi;
		QValidator* validate;
		QString pfix;
		QString sfix;
		QString specText;
		bool wrap;
		bool edited;

		void arrangeWidgets();
		void updateButtonSymbols();

private:	// Disabled copy constructor and operator=
//#if defined(Q_DISABLE_COPY)
		QSpinBox( const QSpinBox& );
		QSpinBox& operator=( const QSpinBox& );
//#endif
*/
};

//#endif // QT_NO_SPINBOX

//#endif // QSPINBOX_H
