/****************************************************************************
** $Id: qvariant.i,v 1.1.1.1 2002/12/22 14:20:18 taka-hr Exp $
**
** Definition of QVariant class
**
** Created : 990414
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/
class QMap_QString_QVariant : public QMap {};
//#ifndef QVARIANT_H
//#define QVARIANT_H

//#ifndef QT_H
//#include "qstring.h"
//#endif // QT_H

class QString;
class QCString;
class QFont;
class QPixmap;
class QBrush;
class QRect;
class QPoint;
class QImage;
class QSize;
class QColor;
class QPalette;
class QColorGroup;
class QIconSet;
class QDataStream;
class QPointArray;
class QRegion;
class QBitmap;
class QCursor;
class QStringList;
// Relevant header files rejected after QVariant declaration
// for GCC 2.7.* compatibility
class QVariant;
class QVariantPrivate;
//template <class T> class QValueList;
//template <class T> class QValueListConstIterator;
//template <class T> class QValueListNode;
//template <class Key, class T> class QMap;
//template <class Key, class T> class QMapConstIterator;

/**
 * This class acts like a union. It can hold one value at the
 * time but it can hold the most common types.
 * For CORBA people: It is a poor mans CORBA::Any.
 */
class QVariant
{
public:
		enum Type {
	Invalid,
	Map,
	List,
	String,
	StringList,
	Font,
	Pixmap,
	Brush,
	Rect,
	Size,
	Color,
	Palette,
	ColorGroup,
	IconSet,
	Point,
	Image,
	Int,
	UInt,
	Bool,
	Double,
	CString,
	PointArray,
	Region,
	Bitmap,
	Cursor
		};

//    QVariant();
		~QVariant();
		%extend {
			 QVariant(VALUE varg0=Qnil, VALUE varg1=Qnil) {
					if(varg0 == Qnil) {
						return new QVariant();
					} else if(varg1 == Qnil) {
						if(rb_obj_is_kind_of(varg0,cQVariant)) {
							 QVariant* qvar;
							 qvar = (QVariant *)Get_QVariant(varg0);
							 return new QVariant(*qvar);
					 } else if(TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString)) {
							 QString *qstr;
							 qstr = (QString *)Get_QString(varg0);
							 return new QVariant(*qstr);
					 }  else if(rb_obj_is_kind_of(varg0,cQStringList)) {
							 QStringList *qtmp;
							 qtmp = (QStringList *)Get_QStringList(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQFont)) {
							 QFont *qtmp;
							 qtmp = (QFont *)Get_QFont(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQPixmap)) {
							 QPixmap *qtmp;
							 qtmp = (QPixmap *)Get_QPixmap(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQImage)) {
							 QImage *qtmp;
							 qtmp = (QImage *)Get_QImage(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQBrush)) {
							 QBrush *qtmp;
							 qtmp = (QBrush *)Get_QBrush(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQPoint)) {
							 QPoint *qtmp;
							 qtmp = (QPoint *)Get_QPoint(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQRect)) {
							 QRect *qtmp;
							 qtmp = (QRect *)Get_QRect(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQRect)) {
							 QRect *qtmp;
							 qtmp = (QRect *)Get_QRect(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQSize)) {
							 QSize *qtmp;
							 qtmp = (QSize *)Get_QSize(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQColor)) {
							 QColor *qtmp;
							 qtmp = (QColor *)Get_QColor(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQPalette)) {
							 QPalette *qtmp;
							 qtmp = (QPalette *)Get_QPalette(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQColorGroup)) {
							 QColorGroup *qtmp;
							 qtmp = (QColorGroup *)Get_QColorGroup(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQIconSet)) {
							 QIconSet *qtmp;
							 qtmp = (QIconSet *)Get_QIconSet(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQPointArray)) {
							 QPointArray *qtmp;
							 qtmp = (QPointArray *)Get_QPointArray(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQRegion)) {
							 QRegion *qtmp;
							 qtmp = (QRegion *)Get_QRegion(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQBitmap)) {
							 QBitmap *qtmp;
							 qtmp = (QBitmap *)Get_QBitmap(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQCursor)) {
							 QCursor *qtmp;
							 qtmp = (QCursor *)Get_QCursor(varg0);
							 return new QVariant(*qtmp);
					 } else if (rb_obj_is_kind_of(varg0,cQSizePolicy)) {
							 QSizePolicy *qtmp;
							 qtmp = (QSizePolicy *)Get_QSizePolicy(varg0);
							 return new QVariant(*qtmp);               
					 } else if (TYPE(varg0) == T_FIXNUM) {
							 int cint;
							 cint = NUM2INT(varg0);
							 return new QVariant(cint);
					 } else if (TYPE(varg0) == T_FLOAT) {
							 double cdbl;
							 cdbl = NUM2DBL(varg0);
							 return new QVariant(cdbl);
					 } else if (varg0 == Qtrue || varg0 == Qfalse) {
							bool cbool=FALSE;
							if(varg0 == Qtrue) 
								 cbool = TRUE;
							 return new QVariant(cbool);
					 } else {
							rb_raise(rb_eTypeError, "Error in value of setProperty()");
					 }
				} else {
					 if(TYPE(varg1) == T_FIXNUM) {
							bool cbool=FALSE;
							int cint;
								if(varg0 == Qtrue)
								cbool=TRUE;
							cint = NUM2INT(varg1);
							return new QVariant(cbool,cint);
					 } else {
							rb_raise(rb_eTypeError, "Error in name of setProperty()");   
					 }
				}
		 }
	}        



						
/*
		QVariant( const QVariant& );
		QVariant( QDataStream& s );

		QVariant( const QString& );
		QVariant( const QCString& );
		QVariant( const char* );
		QVariant( const QStringList& );
		QVariant( const QFont& );
		QVariant( const QPixmap& );
		QVariant( const QImage& );
		QVariant( const QBrush& );
		QVariant( const QPoint& );
		QVariant( const QRect& );
		QVariant( const QSize& );
		QVariant( const QColor& );
		QVariant( const QPalette& );
		QVariant( const QColorGroup& );
		QVariant( const QIconSet& );
		QVariant( const QPointArray& );
		QVariant( const QRegion& );
		QVariant( const QBitmap& );
		QVariant( const QCursor& );
		QVariant( const QValueList<QVariant>& );
		QVariant( const QMap<QString,QVariant>& );
		QVariant( int );
		QVariant( uint );
		// ### Problems on some compilers ?
		QVariant( bool, int );
		QVariant( double );
		QVariant( QSizePolicy);
*/
/*
		QVariant& operator= ( const QVariant& );
		bool operator==( const QVariant& ) const;
		bool operator!=( const QVariant& ) const;
*/
		Type type() const;
		const char* typeName() const;

		bool canCast( Type ) const;

		bool isValid() const;

		void clear();

		const QString toString() const;
		const QCString toCString() const;
		const QStringList toStringList() const;
		const QFont toFont() const;
		const QPixmap toPixmap() const;
		const QImage toImage() const;
		const QBrush toBrush() const;
		const QPoint toPoint() const;
		const QRect toRect() const;
		const QSize toSize() const;
		const QColor toColor() const;
		const QPalette toPalette() const;
		const QColorGroup toColorGroup() const;
		const QIconSet toIconSet() const;
		const QPointArray toPointArray() const;
		const QBitmap toBitmap() const;
		const QRegion toRegion() const;
		const QCursor toCursor() const;
		int toInt() const;
		uint toUInt() const;
		bool toBool() const;
		double toDouble() const;
//typedef QValueList<QVariant> QValueList_QVariant;
		const QValueList_QVariant toList() const;
//    const QValueList<QVariant> toList() const;
//typedef QMap<QString,QVariant> QMap_QString_QVariant;
		const QMap_QString_QVariant toMap() const;
//    const QMap<QString,QVariant> toMap() const;

//    QValueListConstIterator<QVariant> listBegin() const;
//    QValueListConstIterator<QVariant> listEnd() const;
//    QValueListConstIterator<QString> stringListBegin() const;
//    QValueListConstIterator<QString> stringListEnd() const;
//    QMapConstIterator<QString,QVariant> mapBegin() const;
//    QMapConstIterator<QString,QVariant> mapEnd() const;
//    QMapConstIterator<QString,QVariant> mapFind( const QString& ) const;

		QString& asString();
		QCString& asCString();
		QStringList& asStringList();
		QFont& asFont();
		QPixmap& asPixmap();
		QImage& asImage();
		QBrush& asBrush();
		QPoint& asPoint();
		QRect& asRect();
		QSize& asSize();
		QColor& asColor();
		QPalette& asPalette();
		QColorGroup& asColorGroup();
		QIconSet& asIconSet();
		QPointArray& asPointArray();
		QBitmap& asBitmap();
		QRegion& asRegion();
		QCursor& asCursor();
		int& asInt();
		uint& asUInt();
		bool& asBool();
		double& asDouble();
		QValueList_QVariant & asList();
//    QValueList<QVariant>& asList();     
		QMap_QString_QVariant & asMap();
//    QMap<QString,QVariant>& asMap();

//    void load( QDataStream& );
//    void save( QDataStream& ) const;

		static const char* typeToName( Type typ );
		static Type nameToType( const char* name );
/*
private:
		void detach();

		QVariantPrivate* d;
*/
};
/*
class QVariantPrivate : public QShared
{
public:
		QVariantPrivate();
//    QVariantPrivate( QVariantPrivate* );
		~QVariantPrivate();

		void clear();

		QVariant::Type typ;
		union
		{
	uint u;
	int i;
	bool b;
	double d;
	void *ptr;
		} value;
};
*/
//#endif
