/***************************************************************************
										rsignal.cpp  -  description
													 -------------------
	begin                : Sat Aug 18 13:58:52 JST 2001
	copyright            : (C) 2001 by Nobuyuki Horie
	email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "rsignal.h"
#include "qrobject.h"
//#include "qt2_wrap.h"
#include "swig_class_qte.h"

#include <qaccel.h>

#include <qregexp.h>
RSignal::RSignal():
				 arg(NOARG)
{
}
	 
RSignal::RSignal(const char* str):
	arg(NOARG)
{
	 QRegExp argint("\\s*int\\s*");
	 QRegExp argdbl("\\s*double\\s*");
	 QRegExp argbool("\\s*bool\\s*");
	 QRegExp argtext("\\s*const\\s+char\\s*\\*\\s*");
	 QRegExp argobj("\\s*Object\\s*");
	 QRegExp argqstr("\\s*const\\s+QString\\s*\\&\\s*");
	 if(argint.match(str) >= 0) {
			arg = INTARG;
			}
	 else if(argdbl.match(str) >= 0) {
			arg = DBLARG;
			}
	 else if(argbool.match(str) >= 0) {
			arg = BOOLARG;
			//debug("RSignal(bool) created");
			}
	 else if(argtext.match(str) >= 0) {
			arg = TXTARG;
			}
	 else if(argobj.match(str) >= 0) {
			//debug("RSignal(Object) created");
			arg = OBJARG;
			}
	 else if(argqstr.match(str) >= 0) {
			//debug("RSignal(QString) created");
			arg = QSTRARG;
			//QObject::connect(this,SIGNAL(rsignal(const QString &)),
			//		 this,SLOT(transQString(const QString &)));
			}
	 else {
			arg = NOARG;
			}   
}   

RSignal::~RSignal()
{
	 //    debug("RSignal destructed.");
}

void RSignal::connect(const QObject* qobj_rec, const char* qt_slot) 
{

	 QRegExp argint("(\\s*int\\s*)");
	 QRegExp argdbl("(\\s*double\\s*)");
	 QRegExp argbool("(\\s*bool\\s*)");
	 QRegExp argtext("(\\s*const\\s+char\\s*\\*\\s*)");
	 QRegExp argqstr("\\s*const\\s+QString\\s*\\&\\s*");   
	 QRegExp argobj("(\\s*VALUE\\s*)");
	 if(argint.match(qt_slot) > 0) {
			QObject::connect(this, SIGNAL(rsignal(int)), qobj_rec, qt_slot);
			arg = INTARG;
			}
	 else if(argdbl.match(qt_slot) > 0) {
			QObject::connect(this,SIGNAL(rsignal(double)),qobj_rec,qt_slot);
			}
	 else if(argbool.match(qt_slot) > 0) {
			QObject::connect(this, SIGNAL(rsignal(bool)), qobj_rec, qt_slot);
			arg = BOOLARG;
			}      
	 else if(argtext.match(qt_slot) > 0) {
			QObject::connect(this, SIGNAL(rsignal(const char*)), qobj_rec, qt_slot);
			arg = TXTARG;
			}
	 else if(argobj.match(qt_slot) > 0) {
			QObject::connect(this, SIGNAL(rsignal(VALUE)), qobj_rec, qt_slot);
			arg = OBJARG;
			}
	 else if(argqstr.match(qt_slot) > 0) {
			QObject::connect(this,SIGNAL(rsignal(const QString &)), qobj_rec, qt_slot);
			}
	 else {
			QObject::connect(this, SIGNAL(rsignal()), qobj_rec, qt_slot);
			arg = NOARG;
			}   
}
void RSignal::connect(VALUE robj_rec, char* ruby_slot)
{
// Type of signal argment ( int or const char* ) should be
// determined in construction.
	 if ( arg == INTARG ) {
			RSlot* rslot = QRObject::make_rslot("slot(int)",robj_rec,ruby_slot);
			//new RSlotInt(robj_rec,ruby_slot);
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!/n"); return;
			}
			QObject::connect(this,SIGNAL(rsignal(int)), rslot,rslot->qslot());
			//RSlots.append(rslot);
	} else if (arg == DBLARG) {
			RSlot* rslot = QRObject::make_rslot("slot(double)",robj_rec,ruby_slot);
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!\n");return;
			}
			QObject::connect(this,SIGNAL(rsignal(double)),rslot,rslot->qslot());
	} else if ( arg == BOOLARG ) {
			RSlot* rslot = QRObject::make_rslot("slot(bool)",robj_rec,ruby_slot);
			//new RSlotInt(robj_rec,ruby_slot);
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!/n"); return;
			}
			QObject::connect(this,SIGNAL(rsignal(bool)), rslot,rslot->qslot());
			//RSlots.append(rslot);   
	 } else if ( arg == TXTARG || arg == QSTRARG) { 
			RSlot* rslot = QRObject::make_rslot("slot(const char*)",robj_rec,ruby_slot);
			//new RSlotStr(robj_rec,ruby_slot);
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!/n"); return;
			}
			QObject::connect(this,SIGNAL(rsignal(const char*)),rslot,rslot->qslot());  
			//RSlots.append(rslot); 
		}     
		else if ( arg == OBJARG ) { 
			RSlot* rslot = QRObject::make_rslot("slot(VALUE)",robj_rec,ruby_slot);
			//new RSlotRObj(robj_rec,ruby_slot);
			//debug("rsignal(VALUE) connected");
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!/n"); return;
			}
			QObject::connect(this,SIGNAL(rsignal(VALUE)),rslot,rslot->qslot());
			//RSlots.append(rslot);      
		}
		else {
			RSlot* rslot = QRObject::make_rslot("slot()",robj_rec,ruby_slot);
			//new RSlotVoid(robj_rec,ruby_slot);
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!/n"); return;
			}
			QObject::connect(this,SIGNAL(rsignal()),rslot,rslot->qslot());
			//RSlots.append(rslot);
			}
	 
/*
	 QRegExp argint("(\\s*int\\s*)");
	 QRegExp argtext("(\\s*const\\s+char\\s*\\*\\s*)");
	 if(argint.match(ruby_slot) > 0) {
			RSlot* rslot = new RSlot(this,SIGNAL(rsignal(int)),robj_rec,ruby_slot);
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!/n");
			}
			RSlots.append(rslot);
			arg = INTARG;
			}
	 else if(argtext.match(ruby_slot) > 0) {
			RSlot* rslot = new RSlot(this,SIGNAL(rsignal(const char*)),robj_rec,ruby_slot);
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!/n");
			}
			RSlots.append(rslot);      
			arg = TXTARG;
			}
	 else {
			RSlot* rslot = new RSlot(this,SIGNAL(rsignal()),robj_rec,ruby_slot);
			if (rslot == NULL) {
				 fatal("RSlot cannot generate!/n");
			}
			RSlots.append(rslot);
			arg = NOARG;
			}
*/
	 
}

void RSignal::connect_rsignal(RSignal & rsignal) {
	 int arg1(rsignal.type());
	 switch (arg1) {
			case NOARG:
				 if (arg != NOARG) {
						warning("Signal type error in RSignal!");
						//return;
						}
				 QObject::connect(&rsignal,SIGNAL(rsignal()),
						this,SIGNAL(rsignal()));
			break;
			case INTARG:
				 if (arg != INTARG && arg != NOARG ) {
						warning("Signal type error in RSignal!");
						return;
						}
				 if (arg == NOARG) {
						QObject::connect(&rsignal,SIGNAL(rsignal(int)),
							 this,SIGNAL(rsignal()));
					 } else {
						QObject::connect(&rsignal,SIGNAL(rsingal(int)),
							 this,SIGNAL(rsignal(int)));
							 }
			break;

			case DBLARG:
				 if (arg != DBLARG && arg != NOARG) {
						warning("Signal type error in RSignal!");
						return;
						}
				 if (arg == NOARG) {
						QObject::connect(&rsignal,SIGNAL(rsignal(double)),
							 this,SIGNAL(rsignal()));
						} else {
						QObject::connect(&rsignal,SIGNAL(rsignal(double)),
							 this,SIGNAL(rsignal(double)));
							 }
			break;

			case BOOLARG:
				 if (arg != BOOLARG && arg != NOARG) {
						warning("Signal type error in RSignal!");
						return;
						}
				 if (arg == NOARG) {
						QObject::connect(&rsignal,SIGNAL(rsignal(bool)),
							 this,SIGNAL(rsignal()));
					 } else {
						QObject::connect(&rsignal,SIGNAL(rsingal(bool)),
							 this,SIGNAL(rsignal(bool)));
							 }
			break;

			case TXTARG:
				 if (arg != TXTARG || arg != NOARG) {
						warning("Signal type error in RSignal!");
						return;
						}
				 if (arg == NOARG) {
						QObject::connect(&rsignal,SIGNAL(rsignal(const char*)),
							 this,SIGNAL(rsignal()));
					 } else {
						QObject::connect(&rsignal,SIGNAL(rsingal(const char*)),
							 this,SIGNAL(rsignal(const char*)));
							 }
			break;
			case OBJARG:
				 if (arg != OBJARG && arg != NOARG) {
						warning("Singal type error in RSignal!");
						return;
						}
				 if (arg == NOARG) {
						QObject::connect(&rsignal,SIGNAL(rsignal(VALUE)),
							 this,SIGNAL(rsignal()));
					 } else {
						QObject::connect(&rsignal,SIGNAL(rsingal(VALUE)),
							 this,SIGNAL(rsignal(VALUE)));
							 }
			default:
			break;
			}
}
				 
void RSignal::connect_qsignal(const QObject* qobj, const char* qsignal)
{
	 switch( arg ) {
			case NOARG:
			QObject::connect(qobj,qsignal,this,SIGNAL(rsignal()));
			break;
			case TXTARG:
			QObject::connect(qobj,qsignal,this,SIGNAL(rsignal(const char*)));
			break;
			case BOOLARG:
			QObject::connect(qobj,qsignal,this,SIGNAL(rsignal(bool)));      
			break;
			case QSTRARG:
			QObject::connect(qobj,qsignal,this,SIGNAL(rsignal(const QString &)));
			break;
			case INTARG:
			QObject::connect(qobj,qsignal,this,SIGNAL(rsignal(int)));
			break;
			case DBLARG:
			QObject::connect(qobj,qsignal,this,SIGNAL(rsignal(double)));
			break;
			case OBJARG:
			QObject::connect(qobj,qsignal,this,SIGNAL(rsignal(VALUE)));
			break;
			default:
			break;
			}
}
	
bool RSignal::connectItem(QAccel* accel, int id)
{
	 return accel->connectItem(id, this, SIGNAL(rsignal()));
}

bool RSignal::disconnectItem(QAccel* accel, int id)
{
	 return accel->disconnectItem(id, this, SIGNAL(rsignal()));   
}

void RSignal::send()
{
	 if (arg != NOARG) return;
			emit rsignal();
}
void RSignal::send_int(int argint)
{
	 if (arg != INTARG) return;
			emit rsignal(argint);
}
void RSignal::send_double(double argdbl)
{
	 if (arg != DBLARG) return;
	 emit rsignal(argdbl);
}
void RSignal::send_bool(bool argbool)
{
	 if (arg != BOOLARG) return;
			emit rsignal(argbool);
}

void RSignal::send_txt(const char* argtxt)
{
	 if (arg != TXTARG) return;
			emit rsignal(argtxt);
}

void RSignal::send_qstr(QString* qstr)
{
	 if (arg !=QSTRARG) return;
	 emit rsignal(*qstr);
}

void RSignal::send_object(VALUE argobj)
{
	 if (arg != OBJARG) return;
			//debug("rsignal(VALUE) is send");
			emit rsignal(argobj);
}
void RSignal::sendWith(VALUE argobj)
{
	 QString* qstr=0;
	 switch( arg ) {
			case NOARG:
				 send();
			break;
			case INTARG:
				 send_int(NUM2INT(argobj));
			break;
			case DBLARG:
				 send_double(NUM2DBL(argobj));
			break;
			case BOOLARG:
				 if(argobj == Qtrue) send_bool(TRUE);
				 else send_bool(FALSE);
			break;      
			case TXTARG:
				 send_txt(STR2CSTR(argobj));
			break;
			case OBJARG:
				 send_object(argobj);
			break;
			case QSTRARG:
				 qstr = (QString*)Get_QString(argobj);
				 send_qstr(qstr);
			break;
			}
}
void RSignal::reconnect()
{
	 //if(RSlots.isEmpty()) return;
	 //RSlot* rslot;
	 //for(rslot = RSlots.first(); rslot != 0; rslot = RSlots.next()) {
	 //   rslot->connect();
	 //}

}
void RSignal::disconnect()
{
	 //if(RSlots.isEmpty()) return;
	 //RSlot* rslot;
	 //for(rslot = RSlots.first(); rslot != 0; rslot = RSlots.next()) {
	 //   rslot->disconnect();
	 //}
	 QObject::disconnect(this);   
}
void RSignal::transQString(const QString & qstr)
{
	//this function should not be called anymore. 030106
	debug("fixme!, RSignal::transQString called");  
	emit rsignal((const char*)qstr.local8Bit());
}
