/***************************************************************************
                    rubyproc.h  -  description
                           -------------------
  begin                : Tue Jan 7 02:56:00 JST 2003
  copyright            : (C) 2003 by HIDAKA Takahiro
  email                : cv8t-hdk@asahi-net.or.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * $Id: rubyproc.h,v 1.1 2003/01/13 16:14:59 taka-hr Exp $
 * Purpose: For handling ruby thread and signal handling
 * Author:  HIDAKA Takahiro
 */

#ifndef _RubyProc_h
#define _RubyProc_h
#include <sys/time.h>
#include <ruby.h>
#include <rubysig.h>

#include <qobject.h>
#include <qtimer.h>

class RubyProc : public QObject {
  Q_OBJECT

private:
  QTimer *m_tm;
public:
  RubyProc(QObject *parent) : QObject(parent) {
    m_tm = new QTimer(this);
    connect(m_tm, SIGNAL(timeout()), this, SLOT(idleHandler()));
    m_tm->start(0);
  }
  
private slots:
  void idleHandler() {
    // this code is from FXRuby's FXRbApp.cpp
    struct timeval wait;
    wait.tv_sec=0;
    wait.tv_usec=10000;

    // Confirm that this thread can be interrupted, then go to sleep
    CHECK_INTS;
    if(!rb_thread_critical)
      rb_thread_wait_for(wait);    
  }
};
#endif
