// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_2 $
// $Id: keyfilter.cpp,v 1.23 2002/07/12 11:51:46 yamaken Exp $

#include "keyfilter.h"


QChar
KeyEventConverter::extract_qchar(QKeyEvent &e) {
  QChar chr;

  chr = (e.text().length()) ? e.text()[0] : '\0';

  return chr;
}

KeyEventConverter::~KeyEventConverter(void) {
}

QKeyEvent *
KeyEventConverter::create(int unicode, int keycode, int modifiers,
                          bool is_press, bool autorepeat)
{
  QKeyEvent *e;

  e = new QKeyEvent(((is_press) ? QEvent::KeyPress : QEvent::KeyRelease),
                    keycode,
                    QChar(unicode).latin1(),
                    modifiers,
                    QString(QChar(unicode)),
                    autorepeat);

  return e;
}

void
KeyEventConverter::create_by_signal(int unicode, int keycode, int modifiers,
                                    bool is_press, bool autorepeat)
{
  QKeyEvent *e;

  e = create(unicode, keycode, modifiers, is_press, autorepeat);

  emit created(e);
}

void
KeyEventConverter::convert(QKeyEvent *e) {
  int unicode, modifiers;
  bool is_press;

  unicode = e->text().at(0).unicode();
  modifiers = e->state();
  is_press = (e->type() == QEvent::KeyPress);

  emit converted(unicode, e->key(), modifiers, is_press, e->isAutoRepeat());
}

void
CascadeKeyFilter::on_input(QKeyEvent &e) {
  e.ignore();
}

void
CascadeKeyFilter::output(QKeyEvent *e) {
  if (next) {
    next->input(e);
  } else {
    delete e;
  }
}

CascadeKeyFilter::CascadeKeyFilter(void)
  : prev(NULL), next(NULL)
{
}

CascadeKeyFilter::CascadeKeyFilter(const CascadeKeyFilter &orig)
  : prev(orig.prev), next(orig.next)
{
}

CascadeKeyFilter::~CascadeKeyFilter(void) {
}

void
CascadeKeyFilter::insert(CascadeKeyFilter *to_be_prev,
                         CascadeKeyFilter *to_be_next,
                         CascadeKeyFilter *other)
{
  CascadeKeyFilter *end_of_other;

  for (end_of_other = other;
       end_of_other->next;
       end_of_other = end_of_other->next);

  if (to_be_prev) {
    to_be_prev->next = other;
    other->prev = to_be_prev;
  }
  if (to_be_next) {
    end_of_other->next = to_be_next;
    to_be_next->prev = end_of_other;
  }
}

void
CascadeKeyFilter::remove(CascadeKeyFilter *begin, CascadeKeyFilter *end) {
  if (!begin || !end) return;

  if (begin->prev) {
    begin->prev->next = end->next;
  }
  if (end->next) {
    end->next->prev = begin->prev;
  }

  begin->prev = NULL;
  end->next = NULL;
}


void
CascadeKeyFilter::insert_before(CascadeKeyFilter *other) {
  insert(prev, this, other);
}

void
CascadeKeyFilter::insert_after(CascadeKeyFilter *other) {
  insert(this, next, other);
}

void
CascadeKeyFilter::remove(void) {
  remove(this, this);
}

void
CascadeKeyFilter::remove_till(CascadeKeyFilter *end) {
  remove(this, end);
}

void
CascadeKeyFilter::input(QKeyEvent *e) {
  if (is_active()) {
    on_input(*e);
  } else {
    e->ignore();
  }

  if (e->isAccepted()) {
    delete e;
  } else {
    e->accept();
    output(e);
  }
}

CharInjector::~CharInjector(void) {
}

void
CharInjector::inject_char(QChar chr) {
  QString text;
  uchar ascii;
  QKeyEvent *keypress, *keyrelease;

  text = chr;
  ascii = chr.latin1();
  keypress = new QKeyEvent(QEvent::KeyPress, 0, ascii, 0, text, false);
  output(keypress);
  keyrelease = new QKeyEvent(QEvent::KeyRelease, 0, ascii, 0, text, false);
  output(keyrelease);
}

void
CharInjector::inject_str(const QString &str) {
  uint i;
  QChar chr;

  for (i = 0; i < str.length(); i++) {
    chr = str[i];
    inject_char(chr);
  }
}

Command::~Command(void) {
}

DoNothingCommand::~DoNothingCommand(void) {
}

const char *
DoNothingCommand::name(void) const {
  return _name;
}

void
DoNothingCommand::execute(QKeyEvent &e) {
}
