// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_2 $
// $Id: ui_anthy.h,v 1.6 2002/07/12 20:45:27 yamaken Exp $

#ifndef IMKIT_UI_ANTHY_H
#define IMKIT_UI_ANTHY_H

#include "ui.h"
#include "engine_anthy.h"
#include "imwidget_std.h"


class CandidateWindow;

class AnthyGUI : public IMUserInterface {
  Q_OBJECT

public:
  typedef QWidget *(*imwidget_creator_t)(QWidget *parent, Qt::WFlags flags,
                                         Preedit *preedit,
                                         InputMapIndicator *indicator,
                                         CandidateWindow *cand_win);

protected:
  AnthyEngine *_engine;
  CommandMap *_command_map;
  QCharKeyMapper<> *cand_win_keymapper;
  GraphCharMapper<> *graph_keymapper;
  QCharKeyMapper<> *global_ctrl_keymapper, *editing_context_ctrl_keymapper;
  OneShotKeyMapper<> *ctrl_x_mapper;
  ButtonMapper<> *cand_win_btnmapper, *editing_context_ctrl_btnmapper;
  CharInjector *injector;
  Preedit *preedit;
  InputMapIndicator *indicator;
  CandidateWindow *cand_win;
  imwidget_creator_t imwidget_creator;
  QWidget *_imwidget;

private:
  AnthyGUI(void);

protected:
  void connect_signals(void);
  virtual TranslationEngine &engine(void);
  virtual void set_activity(bool activity);

protected slots:
  virtual void update_preedit_state(PreeditState new_state);

public:
  AnthyGUI(AnthyEngine *engine_init,
           Preedit *preedit_init, InputMapIndicator *indicator_init,
           CandidateWindow *cand_win_init,
           imwidget_creator_t imwidget_creator_init);
  virtual ~AnthyGUI(void);
  virtual CascadeKeyFilter *keyfilter_begin(void);
  virtual CascadeKeyFilter *keyfilter_end(void);
  virtual QWidget *imwidget(void);
  virtual QWidget *imwidget(QWidget *parent, Qt::WFlags flags);
  virtual bool is_active(void) const;
  virtual CommandMap *command_map(void);
};

#endif  //IMKIT_UI_ANTHY_H
