// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_3 $
// $Id: ui.h,v 1.4 2002/07/12 11:51:46 yamaken Exp $

#ifndef IMKIT_UI_H
#define IMKIT_UI_H

#include <string>
#include <map>
#include <qwidget.h>
#include "keyfilter.h"
#include "engine.h"


class IMUserInterface : public QObject, public virtual Activatable {
  Q_OBJECT

protected:
  virtual TranslationEngine &engine(void) = 0;

public:
  virtual ~IMUserInterface(void);
  virtual CascadeKeyFilter *keyfilter_begin(void) = 0;
  virtual CascadeKeyFilter *keyfilter_end(void) = 0;
  virtual QWidget *imwidget(void) = 0;
  virtual QWidget *imwidget(QWidget *parent, Qt::WFlags flags) = 0;
  virtual QString name(void);
  virtual void reset_state(void);
  virtual CommandMap *command_map(void) = 0;
  IMKIT_DECLARE_ON_ACTIVATE_HANDLERS;

signals:
#ifndef IMKIT_COMPILE_WITH_PREPROCESSABLE_MOC
  void slot_activated(bool activity);
#else
  IMKIT_DECLARE_SIGNALS_FOR_ACTIVATABLE;
#endif

public slots:
#ifndef IMKIT_COMPILE_WITH_PREPROCESSABLE_MOC
  virtual void slot_activate(bool activity);
#else
  IMKIT_DECLARE_SLOTS_FOR_ACTIVATABLE;
#endif
};

#endif  //IMKIT_UI_H
