// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE5 $
// $Id: engine_anthy.h,v 1.1 2002/08/28 22:13:29 yamaken Exp $

#ifndef IMKIT_ENGINE_ANTHY_H
#define IMKIT_ENGINE_ANTHY_H

extern "C" {
#include <anthy/anthy.h>
#include <anthy/input.h>
}
#include "keyfilter.h"
#include "engine.h"

class QString;
class QTextCodec;
class AnthyEngine;


class AnthySegment : public Segment {
protected:
  //AnthyEngine *engine;
  //Segments::size_type index;
  struct anthy_input_segment *native_segment;
  QString unicode_str;

public:
  //AnthySegment(AnthyEngine *engine_init = 0,
  //             Segments::size_type index_init = 0);
  AnthySegment(struct anthy_input_segment *native_segment_init = 0);
  virtual ~AnthySegment(void);
  virtual const QString &str(void);
  virtual const char *raw_str(void) const;
  virtual Type type(void) const;
  virtual void sync();
  virtual void sync(struct anthy_input_segment *new_native_segment);
};


class AnthyCandidate : public Candidate {
protected:
  QString unicode_str;

public:
  AnthyCandidate(struct anthy_input_segment *native_candidate_init = 0);
  virtual ~AnthyCandidate(void);
  virtual const QString &str(void);
  virtual void sync(struct anthy_input_segment *new_native_candidate);
};


class AnthyEngine : public TranslationEngine {
  Q_OBJECT

protected:
  //n2a stands for Native to Abstract
  static BidirMap<int, InputMap> n2a_inputmap;
  static BidirMap<int, PreeditState> n2a_preedit_state;

  struct anthy_input_config *ai_conf;
  struct anthy_input_context *ai_ctx;
  struct anthy_input_preedit *preedit;
  Segments *segments;
  Candidates *candidates;
  int native_map_state;
  bool prev_candidates_activity;
  CommandMap *_command_map;
  QString committed_str;

protected:
  virtual PreeditState preedit_state(void) const;
  virtual void init_state(void);
  virtual void free_state(void);
  virtual void init_segments(void);
  virtual void init_candidates(void);
  virtual void sync(void);
  virtual void sync_segments(void);
  virtual void sync_candidates(void);
  virtual void activate_candidates(void);
  virtual bool is_converting(void);

public:
  static const QTextCodec *codec(void);

  AnthyEngine(void);
  virtual ~AnthyEngine(void);
  virtual const char *name(void) const;
  virtual InputMap map_state(void) const;
  virtual CommandMap *command_map(void);

  //commands
  void cmd_shrink_segment(void) { anthy_input_resize(ai_ctx, -1); sync(); }
  void cmd_enlarge_segment(void) { anthy_input_resize(ai_ctx, 1); sync(); }
  void cmd_prev_candidate(void) { anthy_input_prev_candidate(ai_ctx); sync(); }
  void cmd_next_candidate(void) { anthy_input_next_candidate(ai_ctx); sync(); }
  void cmd_move_forward(void) { anthy_input_move(ai_ctx, 1); sync(); }
  void cmd_move_back(void) { anthy_input_move(ai_ctx, -1); sync(); }
  void cmd_beginning_of_line(void) { anthy_input_beginning_of_line(ai_ctx); sync(); }
  void cmd_end_of_line(void) { anthy_input_end_of_line(ai_ctx); sync(); }
  void cmd_cut(void) { anthy_input_cut(ai_ctx); sync(); }
  void cmd_erase_prev(void) { anthy_input_erase_prev(ai_ctx); sync(); }
  void cmd_erase_next(void) { anthy_input_erase_next(ai_ctx); sync(); }
  //void cmd_clear(void) { reset(); sync(); }
  void cmd_commit(void) { anthy_input_commit(ai_ctx); sync(); }
  void cmd_quit_one_level(void) { anthy_input_quit(ai_ctx); sync(); }

  //TODO: cmd_select_map(InputMap)ѹ
  //TemplateCommandWithPreArgǥޥåפϿ
  void cmd_select_map_alpha(void) { select_map(IMKIT_INPUT_MAP_ALPHA); }
  void cmd_select_map_walpha(void) { select_map(IMKIT_INPUT_MAP_WALPHA); }
  void cmd_select_map_hiragana(void) { select_map(IMKIT_INPUT_MAP_HIRAGANA); }
  void cmd_select_map_katakana(void) { select_map(IMKIT_INPUT_MAP_KATAKANA); }

  //TODO: cmd_select_candidate()

  void cmd_input_space(void) { anthy_input_space(ai_ctx); sync(); }
  void cmd_self_input_char(QChar chr) { input_char(chr); }

public slots:
  virtual void reset(void);
  virtual void input_str(const QString &str);
  virtual void input_char(QChar chr);
  virtual void select_map(InputMap abstract_new_map);
  virtual void select_candidate(Candidates::size_type which);
};

#endif  // IMKIT_ENGINE_ANTHY_H
