// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE5 $
// $Id: ui_std.h,v 1.4 2003/11/03 04:26:51 yamaken Exp $

#ifndef IMKIT_UI_STD_H
#define IMKIT_UI_STD_H

#include "ui.h"
#include "imwidget.h"

class StdIMWidgetFactory {
protected:
  QObject *_committer;
  Preedit *_preedit;
  InputMapIndicator *_indicator;
  CandidateWindow *_cand_win;
  QWidget *_imwidget;

protected:
  virtual void initialize_imwidget(QWidget *imwidget);

  virtual void initialize_preedit(Preedit *preedit);
  virtual void initialize_inputmap_indicator(InputMapIndicator *indicator);
  virtual void initialize_candidate_window(CandidateWindow *cand_win);

  virtual PreeditWidget *
    create_preedit_widget(QWidget *parent,
                          Qt::WFlags flags,
                          const char *name = "PreeditWidget");
  virtual InputMapIndicatorWidget *
    create_inputmap_indicator_widget(QWidget *parent,
                                     Qt::WFlags flags,
                                     const char *name = "InputMapIndicatorWidget");
  virtual CandidateWindowWidget *
    create_candidate_window_widget(QWidget *parent,
                                   Qt::WFlags flags,
                                   const char *name = "CandidateWindowWidget");

  virtual QWidget *create_imwidget(QWidget *parent, Qt::WFlags flags,
                                   const char *name = "IMWidget");
  virtual Preedit *create_preedit(QWidget *parent, Qt::WFlags flags,
                                  const char *name = "Preedit");
  virtual InputMapIndicator *
    create_inputmap_indicator(QWidget *parent, Qt::WFlags flags,
                              const char *name = "InputMapIndicator");
  virtual CandidateWindow *
    create_candidate_window(QWidget *parent, Qt::WFlags flags,
                            const char *name = "CandidateWindow");

public:
  StdIMWidgetFactory(void);
  virtual ~StdIMWidgetFactory(void);
  virtual QWidget *build(QWidget *parent, Qt::WFlags flags);
  virtual QWidget *imwidget(void);
  virtual Preedit *preedit(void);
  virtual InputMapIndicator *inputmap_indicator(void);
  virtual CandidateWindow *candidate_window(void);
  virtual QObject *committer(void);
};


class StdIMUserInterface : public IMUserInterface {
  Q_OBJECT

protected:
  TranslationEngine *_engine;
  CommandMap *_command_map;
  CascadeKeyFilter *_keyfilter_begin, *_keyfilter_end;
  QObject *committer;
  Preedit *preedit;
  InputMapIndicator *indicator;
  CandidateWindow *cand_win;
  QWidget *_imwidget;
  StdIMWidgetFactory *imwidget_factory;

private:
  StdIMUserInterface(void);

protected:
  virtual CascadeKeyFilter *create_keyfilter(void) = 0;
  virtual void delete_keyfilter(void);
  virtual void connect_signals(void);
  virtual TranslationEngine &engine(void);
  virtual CommandMap *ui_command_map(void);

public:
  StdIMUserInterface(TranslationEngine *engine_init,
                     StdIMWidgetFactory *imwidget_factory_init);
  virtual ~StdIMUserInterface(void);
#ifdef IMKIT_QPE16_EXPERIMENTAL_CONTEXT_RESET
  virtual TranslationEngine *enginep(void);
#endif
  virtual CascadeKeyFilter *keyfilter_begin(void);
  virtual CascadeKeyFilter *keyfilter_end(void);
  virtual QWidget *imwidget(void);
  virtual QWidget *imwidget(QWidget *parent, Qt::WFlags flags);
  virtual CommandMap *command_map(void);
  virtual void assemble_engine(void);
  virtual void purge_engine(void);
};


#endif  //IMKIT_UI_STD_H
