// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE5 $
// $Id: imkit_compactselector.cpp,v 1.7 2003/06/13 10:43:02 yamaken Exp $

#include <qlabel.h>
#include <qsize.h>
#include <qpoint.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qiconset.h>
#include <qapplication.h>
#include <qlineedit.h>
#include <qtopia/resource.h>
#include "imkit_compactselector.h"


IMKitCompactSelectorPixmapRepository *
  IMKitCompactSelectorPixmapRepository::_instance = NULL;


IMKitCompactSelectorPixmapRepository *
IMKitCompactSelectorPixmapRepository::instance(void) {
  if (!_instance) {
    _instance = new IMKitCompactSelectorPixmapRepository();
  }

  return _instance;
}

IMKitCompactSelectorPixmapRepository::
IMKitCompactSelectorPixmapRepository(void)
  : PixmapRepository()
{
}

IMKitCompactSelectorPixmapRepository::
~IMKitCompactSelectorPixmapRepository(void) {
}

QPixmap
IMKitCompactSelectorPixmapRepository::lookup(InputMap map_code) {
  const char *filename;
  QPixmap pm;

  switch (map_code) {
  case IMKIT_INPUT_MAP_HIRAGANA:
    filename = "imkit_compactselector_hira";
    break;

  case IMKIT_INPUT_MAP_KATAKANA:
    filename = "imkit_compactselector_kata";
    break;

  case IMKIT_INPUT_MAP_ALPHA:
    filename = "imkit_compactselector_alnm";
    break;

  case IMKIT_INPUT_MAP_WALPHA:
    filename = "imkit_compactselector_walnm";
    break;

  case IMKIT_INPUT_MAP_HKATAKANA:
    filename = "imkit_compactselector_hkata";
    break;

  default:
    return QPixmap();
  }

  return Resource::loadPixmap(filename);
}

void
IMKitIndicator::mousePressEvent(QMouseEvent *event) {
  qDebug("IMKitCompactSelector::mousePressEvent(QMouseEvent *event)");
  choose();
}

void
IMKitIndicator::choose(void) {
  QPoint point;
  QSize chooser_size;
  int index;

  point = mapToGlobal(geometry().topLeft());
  chooser_size = chooser->sizeHint();
  point.ry() -= chooser_size.height();
  index = chooser->exec(point);
}

IMKitIndicator::IMKitIndicator(QWidget *parent, QPopupMenu *chooser_init)
  : QLabel(parent), chooser(chooser_init)
{
}

IMKitIndicator::~IMKitIndicator(void) {
}

void
IMKitCompactSelector::activated_by_chooser(int index) {
  emit activated(index);
}

IMKitCompactSelector::IMKitCompactSelector(QWidget *parent, const char *name,
                                           WFlags flags)
  : QWidget(parent, name, flags), indicator(NULL), chooser(NULL),
    checked_item(0)
{
  QHBoxLayout *layout;

  layout = new QHBoxLayout(this);
  chooser = new QPopupMenu(this);
  indicator = new IMKitIndicator(this, chooser);
  layout->addWidget(indicator);
  connect(chooser, SIGNAL(activated(int)),
          this, SLOT(activated_by_chooser(int)));
  chooser->setCheckable(true);
}

IMKitCompactSelector::~IMKitCompactSelector(void) {
}

void
IMKitCompactSelector::setCurrentItem(int index) {
  QIconSet *icon;

  chooser->setActiveItem(index);
  chooser->setItemChecked(checked_item, false);
  chooser->setItemChecked(index, true);
  checked_item = index;

  icon = chooser->iconSet(index);
  if (icon) {
    indicator->setPixmap(icon->pixmap());
  } else {
    indicator->setText(chooser->text(index));
  }
  indicator->updateGeometry();
}

// QComboBoxȥ󥿥եߴˤ뤿QPixmap1˼
void
IMKitCompactSelector::insertItem(const QPixmap &pixmap, const QString &label,
                                 int index)
{
  QIconSet iconset(pixmap);

  chooser->insertItem(iconset, label, index);
}

void
IMKitCompactSelector::insertItem(const QString &label, int index) {
  chooser->insertItem(label, index);
}

void
IMKitCompactSelector::clear(void) {
  chooser->clear();
}
