// IMKit-Raw: A Qtopia InputMethod (raw input)
// Copyright (C) 2003  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE6 $
// $Id: imkit_raw_qpe.cpp,v 1.1 2003/12/24 18:51:53 yamaken Exp $

#include <qpixmap.h>
#include "imwidget.h"
#include "imwidget_std.h"
#include "ui.h"
#include "ui_std.h"
#include "engine_raw.h"
#include "ui_raw.h"
#include "platform_qpe.h"


static IMUserInterface *create_custom_raw_ui(StdIMWidgetFactory *elem_factory);
static QPixmap *create_icon(void);

static const char *raw_icon_xpm[];


//TODO: Raw򤵤Ƥǧ䤹Τѹ
static const char *raw_icon_xpm[] = {
"28 14 2 1",
"# c #000000",
". c None",
".........##..##.##..........",
"..........##.##.##..........",
"..........###########.......",
".......##....##.##..........",
"........##..########........",
"........##..##.##.##........",
"............########........",
".........##....##...........",
".........##.########........",
".........##....##...........",
"........##.##########.......",
"........##....##.#..........",
".......##....##..##.........",
".......##..###....###......."
};


static IMUserInterface *
create_custom_raw_ui(StdIMWidgetFactory *elem_factory) {
  RawEngine *engine;
  IMUserInterface *raw_ui;

  engine = new RawEngine;
  raw_ui = new RawGUI(engine, elem_factory);

  return raw_ui;
}

static QPixmap *
create_icon(void) {
  QPixmap *icon;

  icon = new QPixmap((const char **)raw_icon_xpm);

  return icon;
}

IMKIT_EXPORT_INTERFACE(create_custom_raw_ui, create_icon());
