// IMKit-UIM: A Qtopia InputMethod interface for UIM
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE6 $
// $Id: engine_uim.h,v 1.6 2003/11/03 20:49:38 yamaken Exp $

#ifndef IMKIT_ENGINE_UIM_H
#define IMKIT_ENGINE_UIM_H

#include <uim/uim.h>
#include "keyfilter.h"
#include "engine.h"

class QTextCodec;


class UIMSegment : public Segment {
protected:
  int attr;  //UPreeditAttr
  QString unicode_str;

public:
  UIMSegment(int attr_init, const char *raw_str = "");
  virtual ~UIMSegment(void);
  virtual const QString &str(void);
  virtual const char *raw_str(void) const;
  virtual Type type(void) const;
  virtual void sync();
  virtual void sync(const char *raw_str);
};


class UIMCandidate : public Candidate {
protected:
  QString unicode_str;

public:
  UIMCandidate(char *uim_str);
  virtual ~UIMCandidate(void);
  virtual const QString &str(void);
  virtual void sync(char *uim_str);
};


class UIMEngine : public TranslationEngine {
  Q_OBJECT

protected:
  uim_context uim_ctx;
  Segments *segments;
  Candidates *candidates;

  //n2a stands for Native to Abstract
  BidirMap<int, InputMap> n2a_inputmap;
#if 0
  BidirMap<int, PreeditState> n2a_preedit_state;
#endif
  CommandMap *_command_map;

protected:
  //callback interface to adapt to UIM API
  static void cb_commit(void *_this, char *str);
  static void cb_clear(void *_this);
  static void cb_pushback(void *_this, int attr, char *str);
  static void cb_update(void *_this);
  static void cb_set_mode(void *_this, int mode);
  static void cb_set_mode_list_update(void *_this);

  static void cb_candidate_win_activate(void *_this, int nr, int initial_index);
  static void cb_candidate_win_update_focus(void *_this, int index);
  static void cb_candidate_win_deactivate(void *_this);

protected slots:
  //internal slots that receives UIM callbacks
  virtual void slot_commit(char *str);
  virtual void slot_clear(void);
  virtual void slot_pushback(int attr, char *str);
  virtual void slot_update(void);
  virtual void slot_set_mode(int mode);
  virtual void slot_set_mode_list_update(void);
  
  virtual void slot_candidate_win_activate(int nr, int initial_index);
  virtual void slot_candidate_win_update_focus(int index);
  virtual void slot_candidate_win_deactivate(void);

protected:
  virtual PreeditState preedit_state(void) const;
  virtual void init_state(void);
  virtual void free_state(void);
  virtual void init_segments(void);
  virtual void init_candidates(void);
  virtual void sync(void);
#ifndef IMKIT_PASSIVE_INPUTMAP_CONFIGURATION
public:
#endif
  virtual void update_inputmap(void);

public:
  static const QTextCodec *codec(void);

  UIMEngine(void);
  virtual ~UIMEngine(void);
  virtual const char *name(void) const;
  virtual InputMap map_state(void) const;
  virtual CommandMap *command_map(void);
  virtual void update_im_selector(void);

  //commands
  void cmd_receive_keyevent(QKeyEvent &e);
  void cmd_select_map(InputMap new_map);

signals:
  void im_selector_cleared(void);
  void im_added(InputMap im, const QString &label);

public slots:
  virtual void reset(void);
  virtual void input_str(const QString &str);
  virtual void input_char(QChar chr);
  virtual void select_im(InputMap nth);
  virtual void select_map(InputMap new_map);
  virtual void select_candidate(Candidates::size_type nth);
};

#endif  // IMKIT_ENGINE_UIM_H
