// IMKit-UIM: A Qtopia InputMethod interface for UIM
// Copyright (C) 2002,2003  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE6 $
// $Id: uim_keyevent.cpp,v 1.4 2003/12/27 10:50:41 yamaken Exp $

#include <ctype.h>
#include "keyfilter.h"
#include "uim_keyevent.h"


static BidirMap<Qt::Key, UKey>::pair_t q2u_keycode_def[] = {
  {Qt::Key_Escape,    UKey_Escape},
  {Qt::Key_Tab,       UKey_Tab},
  {Qt::Key_Backspace, UKey_Backspace},
  {Qt::Key_Enter,     UKey_Return},  //used prior to next pair
  {Qt::Key_Return,    UKey_Return},
  {Qt::Key_Shift,     (UKey)0},
  {Qt::Key_Control,   (UKey)0},
  {Qt::Key_Alt,       (UKey)0},
  {Qt::Key_Meta,      (UKey)0}
};

static BidirMap<Qt::Key, UKeyModifier>::pair_t q2u_modifier_keycode_def[] = {
  {Qt::Key_Shift,   UKey_Shift},
  {Qt::Key_Control, UKey_Control},
  {Qt::Key_Alt,     UKey_Alt},
  {Qt::Key_Meta,    UKey_Meta}
};

static BidirMap<Qt::ButtonState, UKeyModifier>::pair_t
q2u_modifier_state_def[] = {
  {Qt::NoButton,      (UKeyModifier)0},
  {Qt::ShiftButton,   UKey_Shift},
  {Qt::ControlButton, UKey_Control},
  //{Qt::AltButton,     UKey_Meta},  //used prior to next pair
  {Qt::AltButton,     UKey_Alt}
};


BidirMap<Qt::Key, UKey>
UIMKeyEvent::q2u_keycode(q2u_keycode_def,
                           (sizeof(q2u_keycode_def)
                            / BidirMap<Qt::Key, UKey>::pair_size),
                         Qt::Key_unknown, (UKey)0);

BidirMap<Qt::Key, UKeyModifier>
UIMKeyEvent::q2u_modifier_keycode(q2u_modifier_keycode_def,
                                    (sizeof(q2u_modifier_keycode_def)
                                     / BidirMap<Qt::Key, UKeyModifier>::pair_size),
                                  Qt::Key_unknown, (UKeyModifier)0);

BidirMap<Qt::ButtonState, UKeyModifier>
UIMKeyEvent::q2u_modifier_state(q2u_modifier_state_def,
                                  (sizeof(q2u_modifier_state_def)
                                   / BidirMap<Qt::ButtonState, UKeyModifier>::pair_size),
                                Qt::NoButton, (UKeyModifier)0);


Qt::ButtonState
UIMKeyEvent::extract_modifier_state(QChar chr) {
  //TODO
  return Qt::NoButton;
}

UKeyModifier
UIMKeyEvent::q2u_convert_modifier_state(int qt_modifier_state) {
  int uim_modifier_state, a_modifier;
  BidirMap<Qt::ButtonState, UKeyModifier>::ordinary_map_t::const_iterator i;

  qt_modifier_state &= Qt::KeyButtonMask;

  uim_modifier_state = 0;
  for (i = q2u_modifier_state.ordinary_map.begin();
       i != q2u_modifier_state.ordinary_map.end();
       i++)
  {
    a_modifier = i->first;
    if (qt_modifier_state & a_modifier) {
      uim_modifier_state |= i->second;
    }
  }

  return (UKeyModifier)uim_modifier_state;
}

UIMKeyEvent::UIMKeyEvent(void)
  : accepted(true),
    keycode((UKey)0), modifiers((UKeyModifier)0), is_press(true)
{
}

UIMKeyEvent::UIMKeyEvent(UKey keycode_init, UKeyModifier modifiers_init,
                             bool is_press_init)
  : accepted(true),
    keycode(keycode_init), modifiers(modifiers_init), is_press(is_press_init)
{
}

UIMKeyEvent::UIMKeyEvent(const QKeyEvent &e)
  : accepted(true),
    keycode((UKey)0), modifiers((UKeyModifier)0), is_press(true)
{
  int qt_modifier_state, qt_keycode;
  QChar chr;

  qt_modifier_state = e.state();
  chr = KeyEventConverter::extract_qchar(e);

  if (isascii(e.key())
      && e.key()
      && (isgraph(chr.latin1())
          || isspace(chr.latin1())
          || iscntrl(chr.latin1())))
  {
    keycode = (UKey)imkit_strip_modifier(chr.latin1());
  } else {
    keycode = q2u_keycode.ordinary_map.lookup((Qt::Key)qt_keycode);
  }
  modifiers = q2u_convert_modifier_state(qt_modifier_state);
  is_press = (e.type() == QEvent::KeyPress);
  accepted = e.isAccepted();
}

UIMKeyEvent::~UIMKeyEvent(void) {
}

//UIMKeyEvent::operator QKeyEvent(void) const {
//  //TODO
//}

bool
UIMKeyEvent::is_accepted(void) const {
  return accepted;
}

void
UIMKeyEvent::accept(void) {
  accepted = true;
}

void
UIMKeyEvent::ignore(void) {
  accepted = false;
}
