// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002,2003  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE6 $
// $Id: platform_qpe16.h,v 1.16 2003/12/27 18:09:50 yamaken Exp $

#ifndef IMKIT_PLATFORM_QPE16_H
#define IMKIT_PLATFORM_QPE16_H

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qwindowsystem_qws.h>
#include <qdatastream.h>
#include <qtopia/inputmethodinterface.h>
#include "util.h"
#include "keyfilter.h"
#include "imwidget.h"
#include "ui.h"
#include "ui_std.h"
#include "widgets/imkit_compactselector.h"
#include "platform_qpe.h"


class IMKitInputMethod;
class Qpe16Preedit;
class Qpe16InputMapIndicator;
class Qpe16IMElemFactory;
class ExtIMKitImpl;


class Qpe16QWSKeyBypassIn : public QWSKeyBypassIn {
  Q_OBJECT

protected:
  //empty methods to prevent using KeyboardFilter
  virtual void on_activate(void);
  virtual void on_deactivate(void);

public:
  Qpe16QWSKeyBypassIn(void);
};

#ifdef IMKIT_BROKEN_QPE16_KEYFILTER
class Qpe16QWSKeyBypassOut : public QWSKeyBypassOut {
  Q_OBJECT

protected:
  //empty method to prevent e.accept()
  virtual void on_input(QKeyEvent &e);

public:
  Qpe16QWSKeyBypassOut(void);
};
#endif

class IMKitInputMethod : public QWSInputMethod {
  Q_OBJECT

protected:
  QWSKeyBypassIn *bypass_in;
  QWSKeyBypassOut *bypass_out;

public:
  IMKitInputMethod(QWSKeyBypassIn *bypass_in_init,
                   QWSKeyBypassOut *bypass_out_init);
  virtual ~IMKitInputMethod(void);
  virtual bool filter(int unicode, int keycode, int modifiers, 
                      bool is_press, bool autorepeat);
  virtual void reset(void);
  virtual void setMicroFocus(int x, int y);
  virtual void mouseHandler(int x, int state);
  virtual void compose(const QString& str, int cursor_pos, int focus_len);
  virtual void commit(const QString& str);

public slots:
  virtual void sendback(int unicode, int keycode, int modifiers,
                        bool is_press, bool autorepeat);

signals:
  void focus_changed(const QRect &abs_focus);
#ifdef IMKIT_QPE16_EXPERIMENTAL_CONTEXT_RESET
  //void signal_reset(void);
#endif
};


class Qpe16Preedit : public Preedit {
  Q_OBJECT
  friend Qpe16IMElemFactory;  // for instantiation

protected:
  IMKitInputMethod *qws_im;
  PreeditState _state;

protected:
  Qpe16Preedit(IMKitInputMethod *qws_im_init = NULL);

#ifdef IMKIT_BROKEN_QPE16_PREEDIT_FOCUS
protected slots:
  void notify_focus(const QRect &abs_focus);
#endif

public:
  virtual ~Qpe16Preedit(void);
  virtual void set_qwsinputmethod(IMKitInputMethod *new_qws_im);

  // be obsoleted these bad interfaces
  virtual QWidget *widget(void);
  virtual void set_widget(PreeditWidget *new_adaptee);

public slots:
  virtual void update_state(PreeditState new_state);
  virtual void update(Segments &segments);
  //virtual void select(const QRect &selection);
  virtual void commit(const QString& str);

signals:
  //void cursor_position_changed(int new_position);
  //void focus_changed(int focus_begin, int focus_length);
  //void text_changed(const QString &new_text);
  void focus_changed(const QRect &abs_focus);
};


class Qpe16IMElemFactory : public StdIMWidgetFactory {
protected:
  IMKitInputMethod *qws_im;
  IMKitCompactSelectorPixmapRepository *pixmaps;

protected:
  virtual void initialize_inputmap_indicator(InputMapIndicator *indicator);
  virtual Preedit *create_preedit(QWidget *parent, Qt::WFlags flags,
                                  const char *name = "Preedit");
  InputMapIndicator *create_inputmap_indicator(QWidget *parent,
                                               Qt::WFlags flags,
                                               const char *name = "InputMapIndicator");
  virtual InputMapIndicatorWidget *
    create_inputmap_indicator_widget(QWidget *parent,
                                     Qt::WFlags flags,
                                     const char *name = "InputMapIndicatorWidget");

public:
  Qpe16IMElemFactory(void);
  virtual ~Qpe16IMElemFactory(void);
  virtual QWidget *build(QWidget *parent, Qt::WFlags flags);
  virtual void set_qwsinputmethod(IMKitInputMethod *new_qws_im);
};


class ExtIMKitImpl : public ExtInputMethodInterface {
#ifndef QT_NO_COMPONENT
  Q_REFCOUNT
#endif

private:
  ulong ref;

protected:
  IMKitInputMethod *qws_im;
  IMUserInterface *im_ui;
  QPixmap *_icon;
  QWSKeyBypassIn *bypass_in;
  QWSKeyBypassOut *bypass_out;
  BidirMap<QString, InputMap> str2sym_inputmap;

private:
  ExtIMKitImpl(void);

protected:
  virtual void prepare_key_bypass(void);
  virtual void join_to_bypass(CascadeKeyFilter *im_keyfilter);

public:
  ExtIMKitImpl(IMUserInterface *im_ui_init,
               Qpe16IMElemFactory *elem_factory,
               QPixmap *icon_init = 0);
  virtual ~ExtIMKitImpl(void);
  virtual QString name(void);
  virtual QPixmap *icon(void);
  virtual void resetState(void);
  virtual QWidget *keyboardWidget(QWidget *parent, Qt::WFlags flags);

  virtual QStringList compatible(void);
  virtual QWSInputMethod *inputMethod(void);
  virtual QWidget *statusWidget(QWidget *parent, Qt::WFlags flags);
  virtual void qcopReceive(const QCString &msg, const QByteArray &data);
#ifndef QT_NO_COMPONENT
  QRESULT queryInterface(const QUuid &uuid, QUnknownInterface **interface);
#endif
};


#endif  // IMKIT_PLATFORM_QPE16_H
