// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_4 $
// $Id: ui_anthy.cpp,v 1.16 2002/08/07 01:50:50 yamaken Exp $

#include "ui_anthy.h"


static ButtonMapper<>::keymapdef_t default_cand_win_btnmap[] = {
  {0, ""}
};

static QCharKeyMapper<>::keymapdef_t default_cand_win_keymap[] = {
  //{'a', "select_candidate0"},
  {'\0', ""}
};

static OneShotKeyMapper<>::keymapdef_t default_ctrl_x_map[] = {
  {'j', "select_map_hiragana"},
  {'q', "select_map_katakana"},
  {'l', "select_map_alpha"},
  {'L', "select_map_walpha"},

  //quit prefixed context
  {IMKIT_ASCII_MOD_CTRL('g'), "do_nothing"},

  //{'c', "purge_engine"},

  {'\0', ""}
};

static ButtonMapper<>::keymapdef_t default_editing_context_btnmap[] = {
  {(IMKIT_BTNMAPPER_MOD_SHIFT | Qt::Key_Left), "shrink_segment"},
  {(IMKIT_BTNMAPPER_MOD_SHIFT | Qt::Key_Right), "enlarge_segment"},
  {Qt::Key_Up, "prev_candidate"},
  {Qt::Key_Down, "next_candidate"},
  {Qt::Key_Right, "move_forward"},
  {Qt::Key_Left, "move_back"},
  //{Qt::Key_Backspace, "erase_prev"},  //QWSC-hѴ
  {Qt::Key_Delete, "erase_next"},
  //{Qt::Key_Return, "commit"},  //QWSC-mѴ
  {(IMKIT_BTNMAPPER_MOD_SHIFT | Qt::Key_F30), "quit_one_level"}, //SELECT

#ifdef IMKIT_STEAL_OK_AND_CANCEL_KEY
  //"OK""Cancel"ϥץꥱνλ˳ƤƤ
  //ΤǡȤ٤Ǥʤ
  {Qt::Key_F33, "commit"},  //"OK"
  {Qt::Key_Escape, "quit_one_level"},  //"Cancel"
#endif
  {0, ""}
};

static QCharKeyMapper<>::keymapdef_t default_editing_context_ctrl_keymap[] = {
  {IMKIT_ASCII_MOD_CTRL('i'), "shrink_segment"},
  {IMKIT_ASCII_MOD_CTRL('o'), "enlarge_segment"},
  {IMKIT_ASCII_MOD_CTRL('p'), "prev_candidate"},
  {IMKIT_ASCII_MOD_CTRL('n'), "next_candidate"},
  {IMKIT_ASCII_MOD_CTRL('f'), "move_forward"},
  {IMKIT_ASCII_MOD_CTRL('b'), "move_back"},
  {IMKIT_ASCII_MOD_CTRL('a'), "beginning_of_line"},
  {IMKIT_ASCII_MOD_CTRL('e'), "end_of_line"},
  {IMKIT_ASCII_MOD_CTRL('k'), "cut"},
  {IMKIT_ASCII_MOD_CTRL('h'), "erase_prev"},
  {IMKIT_ASCII_MOD_CTRL('d'), "erase_next"},
  //{IMKIT_ASCII_MOD_CTRL('u'), "clear"},
  //{IMKIT_ASCII_MOD_CTRL('y'), "paste"},
  {IMKIT_ASCII_MOD_CTRL('m'), "commit"},
  {IMKIT_ASCII_MOD_CTRL('j'), "commit"},
  {IMKIT_ASCII_MOD_CTRL('g'), "quit_one_level"},
  {'\0', ""}
};

static ButtonMapper<>::keymapdef_t default_global_btnmap[] = {
  {0, ""}
};

static QCharKeyMapper<>::keymapdef_t default_global_ctrl_keymap[] = {
  {' ', "input_space"},
  {IMKIT_ASCII_MOD_CTRL('x'), "activate_ctrl_x_map"},
  {'\0', ""}
};


TranslationEngine &
AnthyGUI::engine(void) {
  return *_engine;
}

CascadeKeyFilter *
AnthyGUI::create_keyfilter(void) {
  //typedef TemplateCommandWithPreArg<OneShotKeyMapper<>, bool> PrefixMapper;
  typedef TemplateCommandWithPreArg<Activatable, bool> PrefixMapper;

  ctrl_x_mapper = new OneShotKeyMapper<>(default_ctrl_x_map, *command_map());
  (*_command_map)["activate_ctrl_x_map"]
    //= new PrefixMapper(ctrl_x_mapper, &OneShotKeyMapper<>::activate,
    = new PrefixMapper(ctrl_x_mapper, &Activatable::activate,
                       "activate_ctrl_x_map", true);

  cand_win_keymapper
    = new QCharKeyMapper<>(default_cand_win_keymap, *command_map());
  graph_keymapper
    = new GraphCharMapper<>((*command_map())["self_input_char"]);
  global_ctrl_keymapper
    = new QCharKeyMapper<>(default_global_ctrl_keymap, *command_map());
  editing_context_ctrl_keymapper
    = new QCharKeyMapper<>(default_editing_context_ctrl_keymap,
                           *command_map());

  cand_win_btnmapper
    = new ButtonMapper<>(default_cand_win_btnmap, *command_map());
  global_btnmapper
    = new ButtonMapper<>(default_global_btnmap, *command_map());
  editing_context_btnmapper
    = new ButtonMapper<>(default_editing_context_btnmap, *command_map());
  injector = new CharInjector;

  //Ϣ
  *cand_win_btnmapper
    << *cand_win_keymapper
    << *ctrl_x_mapper
    << *editing_context_btnmapper
    << *editing_context_ctrl_keymapper
    << *global_btnmapper
    << *global_ctrl_keymapper
    << *graph_keymapper
    << *injector
    ;
  
  return cand_win_btnmapper;
}

void
AnthyGUI::delete_keyfilter(void) {
  CascadeKeyFilter *i;
  
  for (i = keyfilter_begin()->next(); i != keyfilter_end(); i = i->next()) {
    i->remove();
    delete i;
  }
}

void
AnthyGUI::connect_signals(void) {
  connect(_engine, SIGNAL(preedit_state_changed(PreeditState)),
          this, SLOT(update_preedit_state(PreeditState)));

  connect(_engine, SIGNAL(committed(const QString &)),
          injector, SLOT(inject_str(const QString &)));
  connect(_engine, SIGNAL(map_changed(InputMap)),
          indicator, SLOT(select(InputMap)));
  
  connect(_engine, SIGNAL(preedit_state_changed(PreeditState)),
          preedit, SLOT(update_state(PreeditState)));
  connect(_engine, SIGNAL(segments_changed(Segments &)),
          preedit, SLOT(update(Segments &)));

  connect(_engine, SIGNAL(update_candidates(Candidates &)),
          cand_win, SLOT(update(Candidates &)));
  connect(_engine, SIGNAL(hilight_candidate(int, bool)),
          cand_win, SLOT(hilight(int, bool)));
  connect(_engine, SIGNAL(activation_hint_for_candidates(bool)),
          cand_win, SLOT(slot_activate(bool)));

  //connect(imwidget(), SIGNAL(activated(bool)),
  //        this, SLOT(slot_activate(bool)));
  
  connect(indicator, SIGNAL(selected(InputMap)),
          _engine, SLOT(select_map(InputMap)));
  connect(cand_win, SIGNAL(selected(Candidates::size_type)),
          _engine, SLOT(select_candidate(Candidates::size_type)));
  connect(preedit, SIGNAL(focus_changed(const QRect &)),
          cand_win, SLOT(move_adjacent(const QRect &)));
}

void
AnthyGUI::update_preedit_state(PreeditState new_state) {
  switch (new_state) {
  case IMKIT_PREEDIT_ST_CONV:
  case IMKIT_PREEDIT_ST_CSEG:
  case IMKIT_PREEDIT_ST_EDIT:
    editing_context_ctrl_keymapper->activate();
    editing_context_btnmapper->activate();
    break;

  case IMKIT_PREEDIT_ST_NONE:
  default:
    cand_win_keymapper->deactivate();
    cand_win_btnmapper->deactivate();
    editing_context_ctrl_keymapper->deactivate();
    editing_context_btnmapper->deactivate();
  }
}

AnthyGUI::AnthyGUI(AnthyEngine *engine_init,
                   Preedit *preedit_init, InputMapIndicator *indicator_init,
                   CandidateWindow *cand_win_init,
                   imwidget_creator_t imwidget_creator_init)
  : _engine(engine_init), _command_map(NULL),
    _keyfilter_begin(NULL), _keyfilter_end(NULL),
    cand_win_keymapper(NULL), graph_keymapper(NULL),
    global_ctrl_keymapper(NULL), editing_context_ctrl_keymapper(NULL),
    ctrl_x_mapper(NULL),
    cand_win_btnmapper(NULL),
    global_btnmapper(NULL), editing_context_btnmapper(NULL),
    injector(NULL), preedit(preedit_init),
    indicator(indicator_init), cand_win(cand_win_init),
    imwidget_creator(imwidget_creator_init), _imwidget(NULL)
{
  _keyfilter_begin = new DumbPipe;
  _keyfilter_end = new DumbPipe;
  _keyfilter_begin->insert_after(_keyfilter_end);
  assemble_engine();

}

AnthyGUI::~AnthyGUI(void) {
  purge_engine();
  delete _keyfilter_begin;
  delete _keyfilter_end;
}

CascadeKeyFilter *
AnthyGUI::keyfilter_begin(void) {
  return _keyfilter_begin;
}

CascadeKeyFilter *
AnthyGUI::keyfilter_end(void) {
  return _keyfilter_end;
}

QWidget *
AnthyGUI::imwidget(void) {
  return _imwidget;
}

QWidget *
AnthyGUI::imwidget(QWidget *parent, Qt::WFlags flags) {
  if (!_imwidget) {
    _imwidget = (*imwidget_creator)(parent, flags,
                                    preedit, indicator, cand_win);
    connect(_imwidget, SIGNAL(activated(bool)),
            this, SLOT(slot_activate(bool)));
  }

  return _imwidget;
}

void
AnthyGUI::set_activity(bool activity) {
  //TODO: activate()engine̵äassemble
  ctrl_x_mapper->deactivate();
  graph_keymapper->activate(activity);
  cand_win_keymapper->deactivate();
  cand_win_btnmapper->deactivate();
  global_ctrl_keymapper->activate(activity);
  global_btnmapper->activate(activity);
  editing_context_ctrl_keymapper->deactivate();
  editing_context_btnmapper->deactivate();
  if (!activity) {
    cand_win->deactivate();
  }
}

bool
AnthyGUI::is_active(void) const {
  return (cand_win_keymapper->is_active() || graph_keymapper->is_active());
}

CommandMap *
AnthyGUI::command_map(void) {
  CommandMap *engine_commands;

  if (!_command_map) {
    _command_map = new CommandMap;
    engine_commands = engine().command_map();
    _command_map->insert(engine_commands->begin(), engine_commands->end());
    //"activate_candidate_window"
    //"deactivate_candidate_window"
    //"purge_engine"
    (*_command_map)["do_nothing"] = new DoNothingCommand("do_nothing");
  }

  return _command_map;
}

void
AnthyGUI::assemble_engine(void) {
  _keyfilter_begin->insert_after(create_keyfilter());
  //_engine = new AnthyEngine;  //TODO: ưŪengine
  connect_signals();
  deactivate();
}

void
AnthyGUI::purge_engine(void) {
  deactivate();
  disconnect(preedit, SIGNAL(focus_changed(const QRect &)),
             cand_win, SLOT(move_adjacent(const QRect &)));
  delete_keyfilter();

  {
    //command_map()Ѵ󥸥Υޥɤ
    CommandMap *engine_commands;
    
    engine_commands = engine().command_map();
    command_map()->erase(engine_commands->begin(), engine_commands->end());
  }
  imkit_delete_command_map(_command_map);
  _command_map = NULL;

  delete _engine;
  _engine = NULL;
}
