// IMKit-uim: A Qtopia InputMethod interface for uim
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE9 $
// $Id: ui_uim.h,v 1.8 2004/03/07 07:07:43 yamaken Exp $

#ifndef IMKIT_UI_UIM_H
#define IMKIT_UI_UIM_H

#include "keyfilter.h"
#include "ui.h"
#include "ui_std.h"
#include "engine_uim.h"
#include "widgets/imwidget_std.h"


class UIMGUI : public StdIMUserInterface {
  Q_OBJECT

protected:
  RawMapper<> *forwarder;

protected:
  virtual CascadeKeyFilter *create_keyfilter(void);
  virtual void set_activity(bool activity);

protected slots:
  virtual void update_preedit_state(PreeditState new_state);

public:
  UIMGUI(UIMEngine *engine_init, StdIMWidgetFactory *imwidget_factory_init);
  virtual bool is_active(void) const;
};

#endif  //IMKIT_UI_UIM_H
