// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_1 $
// $Id: ui.cpp,v 1.3 2004/03/07 07:07:43 yamaken Exp $

#include <qapplication.h>
#include "ui.h"

IMUserInterface::IMUserInterface(void) : QObject(NULL, "IMUserInterface") {
}

IMUserInterface::~IMUserInterface(void) {
}

QString
IMUserInterface::name(void) {
  const char *engine_class, *engine_name;

  engine_class = engine().className();
  engine_name = engine().name();

  return qApp->translate(engine_class, engine_name);
}

void
IMUserInterface::reset_state(void) {
  engine().reset();
  if (imwidget() && imwidget()->isVisible()) {
    activate();
  } else {
    deactivate();
  }
}

IMKIT_DEFINE_ON_ACTIVATE_HANDLERS(IMUserInterface)
IMKIT_DEFINE_SLOTS_FOR_ACTIVATABLE(IMUserInterface)
