// IMKit-Raw: A Qtopia InputMethod (raw input)
// Copyright (C) 2003  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_2 $
// $Id: ui_raw.h,v 1.1 2003/12/24 18:51:53 yamaken Exp $

#ifndef IMKIT_UI_RAW_H
#define IMKIT_UI_RAW_H

#include "keyfilter.h"
#include "ui.h"
#include "ui_std.h"
#include "engine_raw.h"
#include "widgets/imwidget_std.h"


class RawGUI : public StdIMUserInterface {
  Q_OBJECT

protected:
  RawMapper<> *forwarder;

protected:
  virtual CascadeKeyFilter *create_keyfilter(void);
  virtual void set_activity(bool activity);

protected slots:
  virtual void update_preedit_state(PreeditState new_state);

public:
  RawGUI(RawEngine *engine_init,
         StdIMWidgetFactory *imwidget_factory_init);
  virtual bool is_active(void) const;
  virtual QWidget *imwidget(QWidget *parent, Qt::WFlags flags);
};

#endif  //IMKIT_UI_RAW_H
