// IMKit-Raw: A Qtopia InputMethod (raw input)
// Copyright (C) 2003  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_4 $
// $Id: engine_raw.h,v 1.3 2004/03/11 05:39:44 yamaken Exp $

#ifndef IMKIT_ENGINE_RAW_H
#define IMKIT_ENGINE_RAW_H

#include "keyfilter.h"
#include "engine.h"


class RawEngine : public TranslationEngine {
  Q_OBJECT

protected:
  CommandMap *_command_map;

public:
  RawEngine(void);
  virtual ~RawEngine(void);
  virtual const char *name(void) const;
  virtual const char *language(void) const;
  virtual InputMap map_state(void) const;
  virtual CommandMap *command_map(void);

  //commands
  void cmd_receive_keyevent(QKeyEvent &e);
  void cmd_select_map(InputMap new_map);

public slots:
  virtual void reset(void);
  virtual void input_str(const QString &str);
  virtual void input_char(QChar chr);
  virtual void select_map(InputMap new_map);
  virtual void select_candidate(Candidates::size_type nth);
};

#endif  // IMKIT_ENGINE_RAW_H
