// IMKit: An inputmethod adaptation library for Qtopia environment
// Copyright (C) 2002-2004  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_4 $
// $Id: imkit_compactselector.cpp,v 1.16 2004/04/01 10:45:32 yamaken Exp $

#include <qlabel.h>
#include <qsize.h>
#include <qpoint.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qiconset.h>
#include <qapplication.h>
#include <qpe/qpeapplication.h>
#include <qpe/resource.h>
#include <qpe/config.h>
#include "imkit_compactselector.h"

#ifdef IMKIT_TEST_QWS_SETIMINFO_COMMAND
#include <qlineedit.h>
#include <qframe.h>

QFrame *test_frame;
#endif

IMKitCompactSelectorPixmapRepository *
  IMKitCompactSelectorPixmapRepository::_instance = NULL;
int IMKitCompactSelectorPixmapRepository::refcnt = 0;


IMKitCompactSelectorPixmapRepository *
IMKitCompactSelectorPixmapRepository::instance(void) {
  if (!_instance) {
    _instance = new IMKitCompactSelectorPixmapRepository();
  }
  refcnt++;

  return _instance;
}

IMKitCompactSelectorPixmapRepository::
IMKitCompactSelectorPixmapRepository(void)
  : PixmapRepository()
{
}

IMKitCompactSelectorPixmapRepository::
~IMKitCompactSelectorPixmapRepository(void) {
}

void
IMKitCompactSelectorPixmapRepository::unref(void) {
  if (!--refcnt) {
    delete _instance;
    _instance = NULL;
  }
}

QPixmap
IMKitCompactSelectorPixmapRepository::lookup(InputMap map_code) {
  Config conf("IMKit");
  QString filename, pics_dir;
  QSize screen_size;
  bool use_vga_icons, has_large_screen;

  screen_size = imkit_screen_size();
  has_large_screen = (640 <= screen_size.width()
                      || 640 <= screen_size.height());

  conf.setGroup("Icons");
  use_vga_icons = conf.readBoolEntry("UseVgaIcons");

  switch (map_code) {
  case IMKIT_INPUT_MAP_HIRAGANA:
    filename = conf.readEntryDirect("HIRAGANA",
                                    "IMKit/imkit_compactselector_hira");
    break;

  case IMKIT_INPUT_MAP_KATAKANA:
    filename = conf.readEntryDirect("KATAKANA",
                                    "IMKit/imkit_compactselector_kata");
    break;

  case IMKIT_INPUT_MAP_ALPHA:
    filename = conf.readEntryDirect("ALPHA",
                                    "IMKit/imkit_compactselector_alnm");
    break;

  case IMKIT_INPUT_MAP_WALPHA:
    filename = conf.readEntryDirect("WALPHA",
                                    "IMKit/imkit_compactselector_walnm");
    break;

  case IMKIT_INPUT_MAP_HKATAKANA:
    filename = conf.readEntryDirect("HKATAKANA",
                                    "IMKit/imkit_compactselector_hkata");
    break;

  case IMKIT_INPUT_MAP_KANJI:
    filename = conf.readEntryDirect("KANJI",
                                    "IMKit/imkit_compactselector_kanji");
    break;

  case IMKIT_INPUT_MAP_RAW:
    filename = conf.readEntryDirect("RAW",
                                    "IMKit/imkit_compactselector_raw");
    break;

  default:
    filename = conf.readEntryDirect("UNKNOWN",
                                    "IMKit/imkit_compactselector_unknown");
  }

  if (use_vga_icons
      || (!conf.hasKey("UseVgaIcons") && has_large_screen))
  {
    pics_dir = "../pics144/";
  } else {
    pics_dir = "";
  }

  return Resource::loadPixmap(pics_dir + filename);
}

void
IMKitIndicator::mousePressEvent(QMouseEvent *event) {
  choose();
}

void
IMKitIndicator::choose(void) {
  QPoint point;
  QSize chooser_size;
  int index;

  point = mapToGlobal(geometry().topLeft());
  chooser_size = chooser->sizeHint();
  point.ry() -= chooser_size.height();
  index = chooser->exec(point);
}

IMKitIndicator::IMKitIndicator(QWidget *parent, QPopupMenu *chooser_init)
  : QLabel(parent), chooser(chooser_init)
{
}

IMKitIndicator::~IMKitIndicator(void) {
}

void
IMKitCompactSelector::activated_by_chooser(int index) {
  emit activated(index);
}

IMKitCompactSelector::IMKitCompactSelector(QWidget *parent, const char *name,
                                           WFlags flags)
  : QWidget(parent, name, flags), indicator(NULL), chooser(NULL),
    checked_item(0)
{
  QHBoxLayout *layout;

  layout = new QHBoxLayout(this);
  chooser = new QPopupMenu(this);
  indicator = new IMKitIndicator(this, chooser);
#ifdef IMKIT_QPE15_USE_IMKITCOMPACTSELECTOR  // temporary solution
  indicator->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  indicator->setLineWidth(1);
#endif

  layout->addWidget(indicator);

#if 0
#ifdef IMKIT_QPE15_USE_IMKITCOMPACTSELECTOR
  QString path = QPEApplication::qpeDir() + "pics/imkit_upper_arrow.xpm";
  QPixmap pixmap(path);
  QLabel *label = new QLabel(this);
  label->setPixmap(pixmap);
  label->setFrameStyle(QFrame::Panel | QFrame::Raised);
  label->setLineWidth(1);
  layout->addWidget(label);
#endif
#endif

  connect(chooser, SIGNAL(activated(int)),
          this, SLOT(activated_by_chooser(int)));
  chooser->setCheckable(true);

#ifdef IMKIT_TEST_QWS_SETIMINFO_COMMAND
  {
    test_frame = new QFrame(NULL, "TestFrame",
                               Qt::WType_TopLevel
                               | Qt::WStyle_Customize
                               | Qt::WStyle_NoBorderEx
                               | Qt::WStyle_StaysOnTop
                               );
    QLineEdit *le = new QLineEdit(test_frame);
    test_frame->show();
  }
#endif
}

IMKitCompactSelector::~IMKitCompactSelector(void) {
}

void
IMKitCompactSelector::setFont(const QFont &new_font) {
  QWidget::setFont(new_font);
  chooser->setFont(new_font); // top-level widget ignores ParentFontChange
}

void
IMKitCompactSelector::setCurrentItem(int index) {
  QIconSet *icon;

  chooser->setActiveItem(index);
  chooser->setItemChecked(checked_item, false);
  chooser->setItemChecked(index, true);
  checked_item = index;

  icon = chooser->iconSet(index);
  if (icon) {
    indicator->setPixmap(icon->pixmap());
  } else {
    indicator->setText(chooser->text(index));
  }
  indicator->updateGeometry();
}

// QComboBoxȥ󥿥եߴˤ뤿QPixmap1˼
void
IMKitCompactSelector::insertItem(const QPixmap &pixmap, const QString &label,
                                 int index)
{
  QIconSet iconset(pixmap);

  chooser->insertItem(iconset, label, index);
}

void
IMKitCompactSelector::insertItem(const QString &label, int index) {
  chooser->insertItem(label, index);
}

void
IMKitCompactSelector::clear(void) {
  chooser->clear();
}
