// IMKit-Utena: A Qtopia InputMethod interface for Utena
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5_PRE_UTENA_902 $
// $Id: engine_utena.cpp,v 1.3 2002/09/02 22:57:01 yamaken Exp $

#include <ctype.h>
#include <string.h>
#include <qtextcodec.h>
#include "utena_keyevent.h"
#include "engine_utena.h"


#if 0
static BidirMap<int, PreeditState>::pair_t n2a_preedit_state_def[] = {
  {UTENA_PUSHBACK_ATTR_CONV, IMKIT_PREEDIT_ST_CONV},
  {UTENA_PUSHBACK_ATTR_CSEG, IMKIT_PREEDIT_ST_CSEG},
  {UTENA_PUSHBACK_ATTR_EDIT, IMKIT_PREEDIT_ST_EDIT},
  {UTENA_PUSHBACK_ATTR_NONE, IMKIT_PREEDIT_ST_NONE}
};

BidirMap<int, PreeditState>
UtenaEngine::n2a_preedit_state(n2a_preedit_state_def,
                               (sizeof(n2a_preedit_state_def)
                                / BidirMap<int, PreeditState>::pair_size),
                               IMKIT_PREEDIT_ST_NONE, UTENA_PUSHBACK_ATTR_NONE);
#endif


UtenaSegment::UtenaSegment(const char *raw_str = "") {
  sync(raw_str);
}

UtenaSegment::~UtenaSegment(void) {
}

const QString &
UtenaSegment::str(void) {
  return unicode_str;
}

const char *
UtenaSegment::raw_str(void) const {
  const char *_raw_str;

  _raw_str = UtenaEngine::codec()->fromUnicode(unicode_str);

  return _raw_str;
}

UtenaSegment::Type
UtenaSegment::type(void) const {
  return IMKIT_SEG_NORMAL;
}

void
UtenaSegment::sync(void) {
}

void
UtenaSegment::sync(const char *raw_str) {
  unicode_str = UtenaEngine::codec()->toUnicode(raw_str);
}

const QTextCodec *
UtenaEngine::codec(void) {
  QTextCodec *_codec;

  _codec = QTextCodec::codecForName("UTF-8");
  _codec = (_codec) ? _codec : QTextCodec::codecForName("ISO8859-1");

  return _codec;
}

UtenaEngine::UtenaEngine(void)
  : utena_ctx(NULL), segments(NULL), _command_map(NULL)
{
  int err;

  err = utena_init();
  init_state();
  sync();
}

UtenaEngine::~UtenaEngine(void) {
  free_state();
  imkit_delete_command_map(_command_map);
}

void
UtenaEngine::reset(void) {
  //free_state();
  //init_state();
  init_segments();
  sync();
}

void
UtenaEngine::init_state(void) {
  char *lang = NULL;
  char *engine = NULL;

  utena_ctx = utena_create_context(this, "UTF-8", lang, engine, cb_commit);
  utena_context_set_preedit_cb(utena_ctx, cb_clear, cb_pushback, cb_update);
  init_segments();
}

void
UtenaEngine::free_state(void) {
  if (utena_ctx) {
    utena_release_context(utena_ctx);
    utena_ctx = NULL;
  }
  imkit_delete_ref_container<Segments>(&segments);
}

void
UtenaEngine::init_segments(void) {
  imkit_init_ref_container<Segments>(&segments);
}

const char *
UtenaEngine::name(void) const {
  return "Utena";
}

InputMap
UtenaEngine::map_state(void) const {
  return IMKIT_INPUT_MAP_HIRAGANA;
}

CommandMap *
UtenaEngine::command_map(void) {
  typedef TemplateCommandWithKeyEvent<UtenaEngine> command_t;
  command_t *cmd;

  if (!_command_map) {
    cmd = new command_t(this,
                        &UtenaEngine::cmd_receive_keyevent,
                        "receive_keyevent");

    _command_map = new CommandMap;
    (*_command_map)["receive_keyevent"] = cmd;
  }

  return _command_map;
}

void
UtenaEngine::cmd_receive_keyevent(QKeyEvent &e) {
  UtenaKeyEvent utena_e(e);
  bool ignored;

  if (utena_e.is_press) {
    ignored = utena_press_key(utena_ctx, utena_e.keycode, utena_e.modifiers);
  } else {
    ignored = utena_release_key(utena_ctx, utena_e.keycode, utena_e.modifiers);
  }
  if (ignored) {
    e.ignore();
  }
}

void
UtenaEngine::input_str(const QString &str) {
  //TODO
}

void
UtenaEngine::input_char(QChar chr) {
  //TODO
}

void
UtenaEngine::select_map(InputMap abstract_new_map) {
}

void
UtenaEngine::select_candidate(Candidates::size_type which) {
}

void
UtenaEngine::cb_commit(void *_this, char *str) {
  ((UtenaEngine *)_this)->slot_commit(str);
}

void
UtenaEngine::cb_clear(void *_this) {
  ((UtenaEngine *)_this)->slot_clear();
}

void
UtenaEngine::cb_pushback(void *_this, int attr, char *str) {
  ((UtenaEngine *)_this)->slot_pushback(attr, str);
}

void
UtenaEngine::cb_update(void *_this) {
  ((UtenaEngine *)_this)->slot_update();
}

void
UtenaEngine::slot_commit(char *str) {
  QString unicode_str;

  unicode_str = codec()->toUnicode(str);
  emit committed(unicode_str);
}

void
UtenaEngine::slot_clear(void) {
  init_segments();
}

void
UtenaEngine::slot_pushback(int attr, char *str) {
  segments->push_back(new UtenaSegment(str));
}

void
UtenaEngine::slot_update(void) {
  sync();
}

PreeditState
UtenaEngine::preedit_state(void) const {
  return IMKIT_PREEDIT_ST_NONE;
}

void
UtenaEngine::sync(void) {
  emit preedit_state_changed(preedit_state());
  emit segments_changed(*segments);
}
