// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5_PRE_UTENA_902 $
// $Id: ui_std.cpp,v 1.1 2002/08/29 14:00:25 yamaken Exp $

#include "ui_std.h"

void
StdIMUserInterface::delete_keyfilter(void) {
  CascadeKeyFilter *i;
  
  for (i = keyfilter_begin()->next(); i != keyfilter_end(); i = i->next()) {
    i->remove();
    delete i;
  }
}

void
StdIMUserInterface::connect_signals(void) {
  connect(_engine, SIGNAL(preedit_state_changed(PreeditState)),
          this, SLOT(update_preedit_state(PreeditState)));

  connect(_engine, SIGNAL(committed(const QString &)),
          injector, SLOT(inject_str(const QString &)));
  connect(_engine, SIGNAL(map_changed(InputMap)),
          indicator, SLOT(select(InputMap)));
  
  connect(_engine, SIGNAL(preedit_state_changed(PreeditState)),
          preedit, SLOT(update_state(PreeditState)));
  connect(_engine, SIGNAL(segments_changed(Segments &)),
          preedit, SLOT(update(Segments &)));

  connect(_engine, SIGNAL(update_candidates(Candidates &)),
          cand_win, SLOT(update(Candidates &)));
  connect(_engine, SIGNAL(hilight_candidate(int, bool)),
          cand_win, SLOT(hilight(int, bool)));
  connect(_engine, SIGNAL(activation_hint_for_candidates(bool)),
          cand_win, SLOT(slot_activate(bool)));

  connect(indicator, SIGNAL(selected(InputMap)),
          _engine, SLOT(select_map(InputMap)));
  connect(cand_win, SIGNAL(selected(Candidates::size_type)),
          _engine, SLOT(select_candidate(Candidates::size_type)));
  connect(preedit, SIGNAL(focus_changed(const QRect &)),
          cand_win, SLOT(move_adjacent(const QRect &)));

  connect(_imwidget, SIGNAL(activated(bool)),
          this, SLOT(slot_activate(bool)));
}

TranslationEngine &
StdIMUserInterface::engine(void) {
  return *_engine;
}

CommandMap *
StdIMUserInterface::ui_command_map(void) {
  CommandMap *_ui_command_map;

  _ui_command_map = new CommandMap;
  (*_ui_command_map)["do_nothing"] = new DoNothingCommand("do_nothing");
  //"activate_candidate_window"
  //"deactivate_candidate_window"
  //"purge_engine"

  return _ui_command_map;
}

StdIMUserInterface::
StdIMUserInterface(TranslationEngine *engine_init,
                   StdIMWidgetFactory *imwidget_factory_init)
  : _engine(engine_init), _command_map(NULL),
    _keyfilter_begin(NULL), _keyfilter_end(NULL), injector(NULL),
    preedit(NULL), indicator(NULL), cand_win(NULL), _imwidget(NULL),
    imwidget_factory(imwidget_factory_init)
{
  _keyfilter_begin = new DumbPipe;
  _keyfilter_end = new DumbPipe;
  _keyfilter_begin->insert_after(_keyfilter_end);
  //assemble_engine();
}

StdIMUserInterface::~StdIMUserInterface(void) {
  purge_engine();
  delete _keyfilter_begin;
  delete _keyfilter_end;
  delete imwidget_factory;
}

CascadeKeyFilter *
StdIMUserInterface::keyfilter_begin(void) {
  return _keyfilter_begin;
}

CascadeKeyFilter *
StdIMUserInterface::keyfilter_end(void) {
  return _keyfilter_end;
}

QWidget *
StdIMUserInterface::imwidget(void) {
  return _imwidget;
}

QWidget *
StdIMUserInterface::imwidget(QWidget *parent, Qt::WFlags flags) {
  if (!_imwidget) {
    _imwidget = imwidget_factory->create_imwidget(parent, flags);
    preedit = imwidget_factory->create_preedit(_imwidget, flags);
    indicator = imwidget_factory->create_inputmap_indicator(_imwidget, flags);
    cand_win = imwidget_factory->create_candidate_window(preedit->widget(),
                                                         flags);
    //connect_signals();
    assemble_engine();
  }

  return _imwidget;
}

CommandMap *
StdIMUserInterface::command_map(void) {
  CommandMap *engine_commands, *ui_commands;

  if (!_command_map) {
    _command_map = new CommandMap;

    engine_commands = engine().command_map();
    ui_commands = ui_command_map();

    _command_map->insert(engine_commands->begin(), engine_commands->end());
    _command_map->insert(ui_commands->begin(), ui_commands->end());
  }

  return _command_map;
}

void
StdIMUserInterface::assemble_engine(void) {
  _keyfilter_begin->insert_after(create_keyfilter());
  //_engine = new AnthyEngine;  //TODO: ưŪengine
  connect_signals();
  deactivate();
}

void
StdIMUserInterface::purge_engine(void) {
  deactivate();
  disconnect(preedit, SIGNAL(focus_changed(const QRect &)),
             cand_win, SLOT(move_adjacent(const QRect &)));
  delete_keyfilter();

  {
    CommandMap *engine_commands;
    
    engine_commands = engine().command_map();
    command_map()->erase(engine_commands->begin(), engine_commands->end());
  }
  imkit_delete_command_map(_command_map);
  _command_map = NULL;

  delete _engine;
  _engine = NULL;
}
