import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;

import javax.swing.*;

/**
 * Ͽޤѥͥ褹륯饹Ǥ
 * @author Kumano Tatsuo
 */
class MapPanel extends JPanel {

	private Map maps;
	private boolean isZoomChanged; // Ψѹ줿ɤ
	private double lastHeight; // ľι⤵
	private double lastMouseX; // ľΥޥɸ
	private double lastMouseY; // ľΥޥɸ
	private double lastWidth; // ľ
	private MapListener mapListener = null;
	private double maxX;
	private double maxY;
	private double minX;
	private double minY;
	private double offsetX; // եå(ºɸ)
	private double offsetY; // եå(ºɸ)
	private double zoom; // ɽΨ
	private boolean isIdle; // 桼ʤ֤ɤ

	/**
	 * 󥹥ȥ饯Ǥ
	 * ե졼Υꤷޤ
	 */
	MapPanel() {
		setBackground(Color.white);
		offsetX = 0;
		offsetY = 0;
		zoom = 1;
		isZoomChanged = true;
		lastMouseX = offsetX;
		lastMouseY = offsetY;
		lastWidth = getWidth();
		lastHeight = getHeight();
		setIdle(true);
		addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				lastMouseX = e.getX();
				lastMouseY = e.getY();
				setIdle(false);
			}
			public void mouseReleased(MouseEvent e) {
				setIdle(true);
				repaint();
			}
		});
		addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent e) {
				offsetX -= e.getX() - lastMouseX;
				offsetY -= e.getY() - lastMouseY;
				lastMouseX = e.getX();
				lastMouseY = e.getY();
				repaint();
				if (mapListener != null) {
					mapListener.mapMoved(new MapEvent(this));
				}
			}
		});
		addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				double newZoom = zoom * (1 + (double) e.getWheelRotation() * e.getClickCount() / 100);
				double newX = (offsetX + e.getX()) / zoom * newZoom - e.getX();
				double newY = (offsetY + e.getY()) / zoom * newZoom - e.getY();
				offsetX = newX;
				offsetY = newY;
				zoom = newZoom;
				isZoomChanged = true;
				repaint();
				if (mapListener != null) {
					mapListener.mapZoomChanged(new MapEvent(this));
				}
			}
		});
		/*
		addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent e) {
				double newZoomX = zoom * getWidth() / lastWidth;
				double newZoomY = zoom * getHeight() / lastHeight;
				double newZoom = Math.sqrt(newZoomX * newZoomY);
				double newOffsetX = offsetX * newZoom / zoom;
				double newOffsetY = offsetY * newZoom / zoom;
				lastWidth = getWidth();
				lastHeight = getHeight();
				offsetX = newOffsetX;
				offsetY = newOffsetY;
				zoom = newZoom;
				isZoomChanged = true;
				repaint();
				if (mapListener != null) {
					mapListener.mapZoomChanged(new MapEvent(this));
				}
			}
		});
		*/
	}

	/**
	 * Υե졼फ桼٥Ȥ뤿ˡꤵ줿ޥåץꥹʤɲäޤ
	 * l  null ξ硢㳰ϥ줺¹Ԥޤ
	 * @param l ޥåץꥹ
	 */
	void addMapListener(MapListener l) {
		mapListener = l;
	}

	/**
	 * @param maps maps (String -> MapData)
	 */
	void setMapData(Map maps) {
		this.maps = maps;
	}

	/**
	 * @return
	 */
	double getMaxX() {
		return maxX;
	}

	/**
	 * @return
	 */
	double getMaxY() {
		return maxY;
	}

	/**
	 * @return
	 */
	double getMinX() {
		return minX;
	}

	/**
	 * @return
	 */
	double getMinY() {
		return minY;
	}

	/**
	 * ֥Ȥ¸ߤϰϤޤ
	 * @return ֥Ȥ¸ߤϰ
	 */
	Rectangle2D getObjectArea() {
		return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
	}

	/**
	 * ɽƤϰϤޤ
	 * @return ɽƤϰ
	 */
	Rectangle2D getVisibleArea() {
		return new Rectangle2D.Double(offsetX / zoom, offsetY / zoom, getWidth() / zoom, getHeight() / zoom);
	}

	/**
	 * Ψޤ
	 * @return Ψ
	 */
	double getZoom() {
		return zoom;
	}

	/**
	 * ꤷ֥Ȥɽꥢˤ뤫ɤޤ
	 * @param shape ֥
	 * @return ꤷ֥Ȥɽꥢˤ뤫ɤ
	 */
	boolean isVisible(Shape shape) {
		return shape.intersects(getVisibleArea());
	}

	/**
	 * Ψѹ줿ɤޤ
	 * @return Ψѹ줿ɤ
	 */
	boolean isZoomChanged() {
		if (isZoomChanged) {
			isZoomChanged = false;
			return true;
		} else {
			return false;
		}
	}

	void moveToCenter() {
		calcMinMaxXY();
		offsetX = (minX + maxX) / 2 * zoom - getWidth() / 2;
		offsetY = (minY + maxY) / 2 * zoom - getHeight() / 2;
	}

	private void calcMinMaxXY() {
		minX = Double.POSITIVE_INFINITY;
		minY = Double.POSITIVE_INFINITY;
		maxX = Double.NEGATIVE_INFINITY;
		maxY = Double.NEGATIVE_INFINITY;
		if (maps != null) {
			for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
				MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
				Rectangle2D bounds = mapData.getBounds();
				if (bounds.getMinX() < minX) {
					minX = bounds.getMinX();
				}
				if (bounds.getMinY() < minY) {
					minY = bounds.getMinY();
				}
				if (maxX < bounds.getMaxX()) {
					maxX = bounds.getMaxX();
				}
				if (maxY < bounds.getMaxY()) {
					maxY = bounds.getMaxY();
				}
			}
		}
	}

	/**
	 * ե졼ब褵˸ƤӽФޤ
	 */
	public void paint(Graphics g) {
		Image image = createImage(getWidth(), getHeight());
		Graphics2D g2 = (Graphics2D) image.getGraphics();
		if (isIdle()) {
			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		}
		g2.setColor(Color.WHITE);
		g2.fillRect(0, 0, getWidth(), getHeight());
		g2.translate(-offsetX, -offsetY);
		g2.scale(zoom, zoom);
		double x = offsetX / zoom;
		double y = offsetY / zoom;
		double w = getWidth() / zoom;
		double h = getHeight() / zoom;
		Font tyomeFont = new Font("MS UI Gothic", Font.PLAIN, 16);
		Font tatemonoFont = new Font("MS UI Gothic", Font.PLAIN, 12);
		Font zyoutiFont = new Font("MS UI Gothic", Font.PLAIN, 15);
		Font mizuFont = new Font("ͣ ī", Font.PLAIN, 14);
		Color waterColor = new Color(200, 210, 250);
		Color zyotiColor = new Color(220, 220, 220);
		Color tatemonoColor = new Color(180, 180, 180);
		Color tyomeAttributeColor = new Color(0, 0, 160);
		try {
			if (maps != null) {
				g2.setStroke(new BasicStroke(1.0f));
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// 褹
						if (mapData.hasGyousei()) {
							g2.setColor(waterColor);
							g2.fill(mapData.getBounds());
							g2.draw(mapData.getBounds());
						}
						// ܤ褹
						if (mapData.hasTyome()) {
							for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
								Polygon polygon = (Polygon) iter2.next();
								if (polygon.getPath() != null) {
									if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_TYOME) {
										if (polygon.getFillColor() != null) {
											g2.setColor(polygon.getFillColor());
										} else {
											g2.setColor(Color.WHITE);
										}
										g2.fill(polygon.getPath());
										g2.draw(polygon.getPath());
									}
								}
							}
						}
					}
				}
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// Ϥ褹
						if (mapData.hasZyouti()) {
							for (Iterator iter2 = mapData.getZyouti().entrySet().iterator(); iter2.hasNext();) {
								Polygon polygon = ((Polygon) ((Map.Entry) iter2.next()).getValue());
								if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_RAILROAD) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_PARK) {
									g2.setColor(new Color(200, 250, 160));
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_SCHOOL) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_TEMPLE) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_GRAVEYARD) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								} else if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_OTHER) {
									g2.setColor(zyotiColor);
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								}
							}
						}
						// ̤褹
						if (mapData.hasMizu()) {
							for (Iterator iter2 = mapData.getMizu().entrySet().iterator(); iter2.hasNext();) {
								g2.setColor(waterColor);
								Polygon polygon = (Polygon) ((Map.Entry) iter2.next()).getValue();
								if (polygon.getPath() != null) {
									g2.fill(polygon.getPath());
									g2.draw(polygon.getPath());
								}
							}
						}
						// ʪ褹
						if (mapData.hasTatemono()) {
							for (Iterator iter2 = mapData.getTatemono().entrySet().iterator(); iter2.hasNext();) {
								g2.setColor(tatemonoColor);
								Polygon polygon = (Polygon) ((Map.Entry) iter2.next()).getValue();
								if (polygon.getPath() != null) {
									g2.fill(polygon.getPath());
								}
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(1.0f));
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// ϳ褹
						if (mapData.hasZyouti()) {
							for (Iterator iter2 = mapData.getOthers().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								if (arc.getType() != Arc.TYPE_RAILWAY) {
									if (arc.getTag() == Arc.TAG_NORMAL) {
										g2.setColor(Color.GRAY);
										g2.draw(arc.getPath());
									}
								}
							}
						}
						// ̳褹
						if (mapData.hasMizuArc()) {
							for (Iterator iter2 = mapData.getMizuArc().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								if (arc.getTag() == Arc.TAG_NORMAL) {
									if (arc.getType() == Arc.TYPE_MIZU_INSIDE) {
										g2.setColor(waterColor.darker());
										g2.draw(arc.getPath());
									}
								}
							}
						}
						// ʪ褹
						if (mapData.hasTatemonoArc()) {
							for (Iterator iter2 = mapData.getTatemonoArc().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								if (arc.getTag() == Arc.TAG_NORMAL) {
									g2.setColor(tatemonoColor.darker());
									g2.draw(arc.getPath());
								}
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(9.0f));
				g2.setColor(Color.GRAY);
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// ƻϩسԤ褹
						if (mapData.hasRoadArc()) {
							for (Iterator iter2 = mapData.getRoadArc().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								g2.draw(arc.getPath());
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(7.0f));
				g2.setColor(Color.WHITE);
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// ƻϩɤĤ֤褹
						if (mapData.hasRoadArc()) {
							for (Iterator iter2 = mapData.getRoadArc().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								g2.draw(arc.getPath());
							}
						}
					}
				}
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// 褹
						if (mapData.hasGyousei()) {
							for (Iterator iter2 = mapData.getGyousei().keySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) mapData.getGyousei().get(iter2.next()));
								if (arc.getTag() == Arc.TAG_NORMAL) {
									if (arc.getType() == Arc.TYPE_GYOUSEI_PREFECTURE
										|| arc.getType() == Arc.TYPE_GYOUSEI_CITY) {
										g2.setColor(Color.BLACK);
										g2.setStroke(new BasicStroke(4.0f));
									} else {
										g2.setColor(Color.BLACK);
										g2.setStroke(new BasicStroke(1.0f));
									}
									g2.draw(arc.getPath());
								}
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(4.0f));
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// Ŵƻ褹
						if (mapData.hasZyouti()) {
							for (Iterator iter2 = mapData.getOthers().entrySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) ((Map.Entry) iter2.next()).getValue());
								if (arc.getType() == Arc.TYPE_RAILWAY) {
									g2.setColor(Color.BLACK);
									g2.draw(arc.getPath());
								}
							}
						}
					}
				}
				g2.setStroke(new BasicStroke(1.0f));
				g2.setColor(Color.BLACK);
				g2.setFont(new Font("default", Font.PLAIN, 300));
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					if (mapData.getBounds().intersects(x, y, w, h)) {
						// 󤬤ʤȤĹ褹
						if (!mapData.hasGyousei()) {
							g2.draw(mapData.getBounds());
							g2.drawString(
								mapData.getMapName(),
								(float) mapData.getBounds().getX(),
								(float) mapData.getBounds().getMaxY());
						}
					}
				}
				g2 = (Graphics2D) image.getGraphics(); // ɸѴ򤷤ʤ
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					// ܤΥ٥褹
					if (mapData.hasTyome()) {
						for (Iterator iter2 = mapData.getTyome().keySet().iterator(); iter2.hasNext();) {
							Polygon polygon = ((Polygon) mapData.getTyome().get(iter2.next()));
							if (polygon.getClassificationCode() == Polygon.CLASSIFICATION_TYOME) {
								if (polygon.getAttribute() != null) {
									g2.setColor(tyomeAttributeColor);
									g2.setFont(tyomeFont);
									FontMetrics metrics = this.getFontMetrics(tyomeFont);
									if (new Rectangle2D
										.Double(x * zoom - offsetX, y * zoom - offsetY, w * zoom, h * zoom)
										.contains(
											polygon.getX() * zoom
												- offsetX
												- metrics.stringWidth(polygon.getAttribute()) / 2,
											polygon.getY() * zoom - offsetY - metrics.getAscent() / 2,
											metrics.stringWidth(polygon.getAttribute()),
											metrics.getAscent())) {
										g2.drawString(
											polygon.getAttribute(),
											(float) (polygon.getX() * zoom - offsetX)
												- metrics.stringWidth(polygon.getAttribute()) / 2,
											(float) (polygon.getY() * zoom - offsetY) + metrics.getAscent() / 2);
									}
								}
							}
						}
					}
					// ʪΥ٥褹
					if (mapData.hasTatemono()) {
						for (Iterator iter2 = mapData.getTatemono().values().iterator(); iter2.hasNext();) {
							Polygon polygon = (Polygon) iter2.next();
							if (polygon.getAttribute() != null) {
								g2.setColor(Color.BLACK);
								g2.setFont(tatemonoFont);
								FontMetrics metrics = this.getFontMetrics(tatemonoFont);
								if (new Rectangle2D
									.Double(x * zoom - offsetX, y * zoom - offsetY, w * zoom, h * zoom)
									.contains(
										polygon.getX() * zoom
											- offsetX
											- metrics.stringWidth(polygon.getAttribute()) / 2,
										polygon.getY() * zoom - offsetY - metrics.getAscent() / 2,
										metrics.stringWidth(polygon.getAttribute()),
										metrics.getAscent())) {
									g2.drawString(
										polygon.getAttribute(),
										(float) (polygon.getX() * zoom - offsetX)
											- metrics.stringWidth(polygon.getAttribute()) / 2,
										(float) (polygon.getY() * zoom - offsetY) + metrics.getAscent() / 2);
								}
							}
						}
					}
					// ϤΥ٥褹
					if (mapData.hasZyouti()) {
						for (Iterator iter2 = mapData.getZyouti().values().iterator(); iter2.hasNext();) {
							Polygon polygon = (Polygon) iter2.next();
							if (polygon.getAttribute() != null) {
								g2.setColor(Color.BLACK);
								g2.setFont(zyoutiFont);
								FontMetrics metrics = this.getFontMetrics(zyoutiFont);
								if (new Rectangle2D
									.Double(x * zoom - offsetX, y * zoom - offsetY, w * zoom, h * zoom)
									.contains(
										polygon.getX() * zoom
											- offsetX
											- metrics.stringWidth(polygon.getAttribute()) / 2,
										polygon.getY() * zoom - offsetY - metrics.getAscent() / 2,
										metrics.stringWidth(polygon.getAttribute()),
										metrics.getAscent())) {
									g2.drawString(
										polygon.getAttribute(),
										(float) (polygon.getX() * zoom - offsetX)
											- metrics.stringWidth(polygon.getAttribute()) / 2,
										(float) (polygon.getY() * zoom - offsetY) + metrics.getAscent() / 2);
								}
							}
						}
					}
					// ̤Υ٥褹
					if (mapData.hasMizu()) {
						for (Iterator iter2 = mapData.getMizu().values().iterator(); iter2.hasNext();) {
							Polygon polygon = (Polygon) iter2.next();
							if (polygon.getAttribute() != null) {
								g2.setColor(waterColor.darker().darker());
								g2.setFont(mizuFont);
								FontMetrics metrics = this.getFontMetrics(mizuFont);
								if (new Rectangle2D
									.Double(x * zoom - offsetX, y * zoom - offsetY, w * zoom, h * zoom)
									.contains(
										polygon.getX() * zoom
											- offsetX
											- metrics.stringWidth(polygon.getAttribute()) / 2,
										polygon.getY() * zoom - offsetY - metrics.getAscent() / 2,
										metrics.stringWidth(polygon.getAttribute()),
										metrics.getAscent())) {
									g2.drawString(
										polygon.getAttribute() ,
										(float) (polygon.getX() * zoom - offsetX)
											- metrics.stringWidth(polygon.getAttribute()) / 2,
										(float) (polygon.getY() * zoom - offsetY) + metrics.getAscent() / 2);
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			System.err.println("Failed to draw map.");
			e.printStackTrace(System.err);
		}
		g.drawImage(image, 0, 0, this);
	}

	/**
	 * ºɸޤ
	 * @param location ۺɸ
	 * @return ºɸ
	 */
	Point2D toRealLocation(Point2D location) {
		return new Point2D.Double(location.getX() * zoom - offsetX, location.getY() * zoom - offsetY);
	}

	/**
	 * ۺɸޤ
	 * @param location ºɸ
	 * @return ۺɸ
	 */
	Point2D toVirtualLocation(Point2D location) {
		return new Point2D.Double((offsetX + location.getX()) / zoom, (offsetY + location.getY()) / zoom);
	}

	void zoom(double zoom) {
		this.zoom = zoom;
		isZoomChanged = true;
		if (mapListener != null) {
			mapListener.mapZoomChanged(new MapEvent(this));
		}
	}

	/**
	 * ưΨꤷޤ 
	 */
	void zoomAutomaticaly() {
		calcMinMaxXY();
		double zoomX = getWidth() / (maxX - minX);
		double zoomY = getHeight() / (maxY - minY);
		if (zoomY < zoomX) {
			zoom = zoomY;
		} else {
			zoom = zoomX;
		}
		isZoomChanged = true;
		if (mapListener != null) {
			mapListener.mapZoomChanged(new MapEvent(this));
		}
	}

	/**
	 * @param b
	 */
	private void setIdle(boolean b) {
		isIdle = b;
	}

	/**
	 * @return
	 */
	boolean isIdle() {
		return isIdle;
	}

}
