#============================================================================================================
#
#	[UʒmǗW[
#
#============================================================================================================
package	GANDALF;

use strict;
#use warnings;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	W[IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $class = shift;
	
	my $obj = {
		'TO'		=> undef,
		'FROM'		=> undef,
		'SUBJECT'	=> undef,
		'TEXT'		=> undef,
		'DATE'		=> undef,
		'LIMIT'		=> undef,
	};
	bless $obj, $class;
	
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒmǂݍ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Load
{
	my $this = shift;
	my ($Sys) = @_;
	
	# nbV
	$this->{'TO'} = {};
	$this->{'FROM'} = {};
	$this->{'SUBJECT'} = {};
	$this->{'TEXT'} = {};
	$this->{'DATE'} = {};
	$this->{'LIMIT'} = {};
	
	my $path = '.' . $Sys->Get('INFO') . '/notice.cgi';
	
	if (open(my $fh, '<', $path)) {
		flock($fh, 2);
		my @lines = <$fh>;
		close($fh);
		map { s/[\r\n]+\z// } @lines;
		
		foreach (@lines) {
			next if ($_ eq '');
			
			my @elem = split(/<>/, $_, -1);
			if (scalar(@elem) < 7) {
				warn "invalid line in $path";
				#next;
			}
			
			my $id = $elem[0];
			$this->{'TO'}->{$id} = $elem[1];
			$this->{'FROM'}->{$id} = $elem[2];
			$this->{'SUBJECT'}->{$id} = $elem[3];
			$this->{'TEXT'}->{$id} = $elem[4];
			$this->{'DATE'}->{$id} = $elem[5];
			$this->{'LIMIT'}->{$id} = $elem[6];
		}
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒmۑ
#	-------------------------------------------------------------------------------------
#	@param	$Sys	MELKOR
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Save
{
	my $this = shift;
	my ($Sys) = @_;
	
	foreach my $id (keys %{$this->{'TO'}}) {
		if ($this->IsLimitOut($id)) {
			$this->Delete($id);
		}
	}
	
	my $path = '.' . $Sys->Get('INFO') . '/notice.cgi';
	
	if (open(my $fh, (-f $path ? '+<' : '>'), $path)) {
		flock($fh, 2);
		seek($fh, 0, 0);
		binmode($fh);
		
		foreach (keys %{$this->{'TO'}}) {
			my $data = join('<>',
				$_,
				$this->{'TO'}->{$_},
				$this->{'FROM'}->{$_},
				$this->{'SUBJECT'}->{$_},
				$this->{'TEXT'}->{$_},
				$this->{'DATE'}->{$_},
				$this->{'LIMIT'}->{$_}
			);
			
			print $fh "$data\n";
		}
		
		truncate($fh, tell($fh));
		close($fh);
	}
	chmod $Sys->Get('PM-ADM'), $path;
}

#------------------------------------------------------------------------------------------------------------
#
#	IDZbg擾
#	-------------------------------------------------------------------------------------
#	@param	$kind	
#	@param	$name	[h
#	@param	$pBuf	IDZbgi[obt@
#	@return	L[Zbg
#
#------------------------------------------------------------------------------------------------------------
sub GetKeySet
{
	my $this = shift;
	my ($kind, $name, $pBuf) = @_;
	
	my $n = 0;
	
	if ($kind eq 'ALL') {
		$n += push @$pBuf, keys(%{$this->{'TO'}});
	}
	else {
		foreach my $key (keys(%{$this->{$kind}})) {
			if (($this->{$kind}->{$key} eq $name) || ($kind eq 'ALL')) {
				$n += push @$pBuf, $key;
			}
		}
	}
	
	return $n;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm擾
#	-------------------------------------------------------------------------------------
#	@param	$kind		
#	@param	$key		ID
#	@param	$default	ftHg
#	@return	
#
#------------------------------------------------------------------------------------------------------------
sub Get
{
	my $this = shift;
	my ($kind, $key, $default) = @_;
	
	my $val = $this->{$kind}->{$key};
	
	return (defined $val ? $val : (defined $default ? $default : undef));
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒmǉ
#	-------------------------------------------------------------------------------------
#	@param	$to		ʒm惆[U
#	@param	$from	M[U
#	@param	$subj	^Cg
#	@param	$text	e
#	@param	$limit	
#	@return	ID
#
#------------------------------------------------------------------------------------------------------------
sub Add
{
	my $this = shift;
	my ($to, $from, $subj, $text, $limit) = @_;
	
	my $id = time;
	$id++ while (exists $this->{'TO'}->{$id});
	
	$this->{'TO'}->{$id}		= $to;
	$this->{'FROM'}->{$id}		= $from;
	$this->{'SUBJECT'}->{$id}	= $subj;
	$this->{'TEXT'}->{$id}		= $text;
	$this->{'DATE'}->{$id}		= time;
	$this->{'LIMIT'}->{$id}		= $limit;
	
	return $id;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒmݒ
#	-------------------------------------------------------------------------------------
#	@param	$id		ID
#	@param	$kind	
#	@param	$val	ݒl
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Set
{
	my $this = shift;
	my ($id, $kind, $val) = @_;
	
	if (exists $this->{$kind}->{$id}) {
		$this->{$kind}->{$id} = $val;
	}
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm폜
#	-------------------------------------------------------------------------------------
#	@param	$id		폜ID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub Delete
{
	my $this = shift;
	my ($id) = @_;
	
	delete $this->{'TO'}->{$id};
	delete $this->{'FROM'}->{$id};
	delete $this->{'SUBJECT'}->{$id};
	delete $this->{'TEXT'}->{$id};
	delete $this->{'DATE'}->{$id};
	delete $this->{'LIMIT'}->{$id};
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm񔻒
#	-------------------------------------------------------------------------------------
#	@param	$id		ʒmID
#	@param	$user	[UID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub IsInclude
{
	my $this = shift;
	my ($id, $user) = @_;
	
	# S̒ʒm
	if ($this->{'TO'}->{$id} eq '*') {
		return 1;
	}
	
	my @users = split(/\, ?/, $this->{'TO'}->{$id});
	foreach (@users) {
		if ($_ eq $user) {
			return 1;
		}
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm؂ꔻ
#	-------------------------------------------------------------------------------------
#	@param	$id		ʒmID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub IsLimitOut
{
	my $this = shift;
	my ($id) = @_;
	
	# S̒ʒm̏ꍇ̂
	if ($this->{'TO'}->{$id} eq '*') {
		my $now = time;
		if ($now > $this->{'LIMIT'}->{$id}) {
			return 1;
		}
	}
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	ʒm惆[U폜
#	-------------------------------------------------------------------------------------
#	@param	$id		ʒmID
#	@param	$user	[UID
#	@return	Ȃ
#
#------------------------------------------------------------------------------------------------------------
sub RemoveToUser
{
	my $this = shift;
	my ($id, $user) = @_;
	
	# S̒ʒm͌ʍ폜s
	if ($this->{'TO'}->{$id} eq '*') {
		return;
	}
	
	my @users = split(/\, ?/, $this->{'TO'}->{$id});
	my @news = ();
	foreach (@users) {
		if ($_ ne $user) {
			push(@news, $_);
		}
	}
	
	# ׂĂ̒ʒm惆[U폜ꂽA̒ʒm͔j
	if (scalar(@news) == 0) {
		$this->Delete($id);
	}
	else {
		$this->{'TO'}->{$id} = join(',', @news);
	}
}

#============================================================================================================
#	Module END
#============================================================================================================
1;
