package CGI::Session;use strict;use Carp;use CGI::Session::ErrorHandler;@CGI::Session::ISA=qw(CGI::Session::ErrorHandler);$CGI::Session::VERSION='4.48';$CGI::Session::NAME='CGISESSID';$CGI::Session::IP_MATCH=0;sub STATUS_UNSET(){1<<0}sub STATUS_NEW(){1<<1}sub STATUS_MODIFIED(){1<<2}sub STATUS_DELETED(){1<<3}sub STATUS_EXPIRED(){1<<4}sub import{my($class,@args)=@_;return unless@args;ARG:for my$arg(@args){if($arg eq '-ip_match'){$CGI::Session::IP_MATCH=1;last ARG;}}}sub new{my($class,@args)=@_;my$self;if(ref$class){$self=bless{%$class},ref($class);$class=ref$class;$self->_reset_status();}else{$class->set_error('');$self=$class->load(@args);if(not defined$self){return$class->set_error("new(): failed: ".$class->errstr);}}my$dataref=$self->{_DATA};unless($dataref->{_SESSION_ID}){my$id=$self->_id_generator()->generate_id($self->{_DRIVER_ARGS},$self->{_CLAIMED_ID});unless(defined$id){return$self->set_error("Couldn't generate new SESSION-ID");}$dataref->{_SESSION_ID}=$id;$dataref->{_SESSION_CTIME}=$dataref->{_SESSION_ATIME}=time();$dataref->{_SESSION_REMOTE_ADDR}=$ENV{REMOTE_ADDR}||"";$self->_set_status(STATUS_NEW);}return$self;}sub DESTROY{$_[0]->flush()}sub close{$_[0]->flush()}*param_hashref=\&dataref;my$avoid_single_use_warning=*param_hashref;sub dataref{$_[0]->{_DATA}}sub is_empty{!defined($_[0]->id)}sub is_expired{$_[0]->_test_status(STATUS_EXPIRED)}sub is_new{$_[0]->_test_status(STATUS_NEW)}sub id{return defined($_[0]->dataref)?$_[0]->dataref->{_SESSION_ID}:undef}sub atime{return defined($_[0]->dataref)?$_[0]->dataref->{_SESSION_ATIME}:undef}sub ctime{return defined($_[0]->dataref)?$_[0]->dataref->{_SESSION_CTIME}:undef}sub _driver{my$self=shift;defined($self->{_OBJECTS}->{driver})and return$self->{_OBJECTS}->{driver};my$pm="CGI::Session::Driver::".$self->{_DSN}->{driver};defined($self->{_OBJECTS}->{driver}=$pm->new($self->{_DRIVER_ARGS}))or die$pm->errstr();return$self->{_OBJECTS}->{driver};}sub _serializer{my$self=shift;defined($self->{_OBJECTS}->{serializer})and return$self->{_OBJECTS}->{serializer};return$self->{_OBJECTS}->{serializer}="CGI::Session::Serialize::".$self->{_DSN}->{serializer};}sub _id_generator{my$self=shift;defined($self->{_OBJECTS}->{id})and return$self->{_OBJECTS}->{id};return$self->{_OBJECTS}->{id}="CGI::Session::ID::".$self->{_DSN}->{id};}sub ip_matches{return($_[0]->{_DATA}->{_SESSION_REMOTE_ADDR}eq$ENV{REMOTE_ADDR});}sub parse_dsn{my$self=shift;my$dsn_str=shift;croak"parse_dsn(): usage error"unless$dsn_str;require Text::Abbrev;my$abbrev=Text::Abbrev::abbrev("driver","serializer","id");my%dsn_map=map{split/:/}(split/;/,$dsn_str);my%dsn=map{$abbrev->{lc$_},lc$dsn_map{$_}}keys%dsn_map;return\%dsn;}sub query{my$self=shift;if($self->{_QUERY}){return$self->{_QUERY};}require CGI;return$self->{_QUERY}=CGI->new();}sub name{my$self=shift;my$name=shift;if(ref$self){unless(defined$name){return$self->{_NAME}||$CGI::Session::NAME;}return$self->{_NAME}=$name;}$CGI::Session::NAME=$name if defined$name;return$CGI::Session::NAME;}sub dump{my$self=shift;require Data::Dumper;my$d=Data::Dumper->new([$self],[ref$self]);$d->Deepcopy(1);return$d->Dump();}sub _set_status{my$self=shift;croak"_set_status(): usage error"unless@_;$self->{_STATUS}|=$_[0];}sub _unset_status{my$self=shift;croak"_unset_status(): usage error"unless@_;$self->{_STATUS}&=~$_[0];}sub _reset_status{$_[0]->{_STATUS}=STATUS_UNSET;}sub _test_status{return$_[0]->{_STATUS}&$_[1];}sub flush{my$self=shift;return unless$self->id;return if!defined($self->{_STATUS})or$self->{_STATUS}==STATUS_UNSET;if($self->_test_status(STATUS_NEW)&&$self->_test_status(STATUS_DELETED)){$self->{_DATA}={};return$self->_unset_status(STATUS_NEW|STATUS_DELETED);}my$driver=$self->_driver();my$serializer=$self->_serializer();if($self->_test_status(STATUS_DELETED)){defined($driver->remove($self->id))or return$self->set_error("flush(): couldn't remove session data: ".$driver->errstr);$self->{_DATA}={};return$self->_unset_status(STATUS_DELETED);}if($self->_test_status(STATUS_NEW|STATUS_MODIFIED)){my$datastr=$serializer->freeze($self->dataref);unless(defined$datastr){return$self->set_error("flush(): couldn't freeze data: ".$serializer->errstr);}defined($driver->store($self->id,$datastr))or return$self->set_error("flush(): couldn't store datastr: ".$driver->errstr);$self->_unset_status(STATUS_NEW|STATUS_MODIFIED);}return 1;}sub trace{}sub tracemsg{}sub param{my($self,@args)=@_;if($self->_test_status(STATUS_DELETED)){carp"param(): attempt to read/write deleted session";}if(@args==0){return grep{!/^_SESSION_/}keys%{$self->{_DATA}};}elsif(@args==1){return$self->{_DATA}->{$args[0]}}my%args=@args;my($name,$value)=@args{qw(-name -value)};if(defined$name&&defined$value){if($name=~m/^_SESSION_/){carp"param(): attempt to write to private parameter";return undef;}$self->_set_status(STATUS_MODIFIED);return$self->{_DATA}->{$name}=$value;}return$self->{_DATA}->{$args{'-name'}}if defined$args{'-name'};if((@args%2)==0){my$modified_cnt=0;ARG_PAIR:while(my($name,$val)=each%args){if($name=~m/^_SESSION_/){carp"param(): attempt to write to private parameter";next ARG_PAIR;}$self->{_DATA}->{$name}=$val;++$modified_cnt;}$self->_set_status(STATUS_MODIFIED);return$modified_cnt;}croak"param(): usage error. Invalid syntax";}sub delete{$_[0]->_set_status(STATUS_DELETED)}*header=\&http_header;my$avoid_single_use_warning_again=*header;sub http_header{my$self=shift;return$self->query->header(-cookie=>$self->cookie,-type=>'text/html',@_);}sub cookie{my$self=shift;my$query=$self->query();my$cookie=undef;if($self->is_expired){$cookie=$query->cookie(-name=>$self->name,-value=>$self->id,-expires=>'-1d',@_);}elsif(my$t=$self->expire){$cookie=$query->cookie(-name=>$self->name,-value=>$self->id,-expires=>'+'.$t.'s',@_);}else{$cookie=$query->cookie(-name=>$self->name,-value=>$self->id,@_);}return$cookie;}sub save_param{my$self=shift;my($query,$params)=@_;$query||=$self->query();$params||=[$query->param];for my$p(@$params){my@values=$query->param($p)or next;if(@values>1){$self->param($p,\@values);}else{$self->param($p,$values[0]);}}$self->_set_status(STATUS_MODIFIED);}sub load_param{my$self=shift;my($query,$params)=@_;$query||=$self->query();$params||=[$self->param];for(@$params){$query->param(-name=>$_,-value=>$self->param($_));}}sub clear{my$self=shift;my$params=shift;if(defined$params){$params=[$params]unless ref$params;}else{$params=[$self->param];}for(grep{!/^_SESSION_/}@$params){delete$self->{_DATA}->{$_};}$self->_set_status(STATUS_MODIFIED);}sub find{my$class=shift;my($dsn,$coderef,$dsn_args);if(@_==1){$coderef=$_[0];}else{($dsn,$coderef,$dsn_args)=@_;}unless($coderef&&ref($coderef)&&(ref$coderef eq 'CODE')){croak"find(): usage error.";}my$driver;if($dsn){my$hashref=$class->parse_dsn($dsn);$driver=$hashref->{driver};}$driver||="file";my$pm="CGI::Session::Driver::".($driver=~/(.*)/)[0];eval"require $pm";if(my$errmsg=$@){return$class->set_error("find(): couldn't load driver.".$errmsg);}my$driver_obj=$pm->new($dsn_args);unless($driver_obj){return$class->set_error("find(): couldn't create driver object. ".$pm->errstr);}my$read_only=1;my$driver_coderef=sub{my($sid)=@_;my$session=$class->load($dsn,$sid,$dsn_args,$read_only);unless($session){return$class->set_error("find(): couldn't load session '$sid'. ".$class->errstr);}$coderef->($session);};defined($driver_obj->traverse($driver_coderef))or return$class->set_error("find(): traverse seems to have failed. ".$driver_obj->errstr);return 1;}sub load{my$class=shift;return$class->set_error("called as instance method")if ref$class;return$class->set_error("Too many arguments provided to load()")if@_>5;my$self=bless{_DATA=>{_SESSION_ID=>undef,_SESSION_CTIME=>undef,_SESSION_ATIME=>undef,_SESSION_REMOTE_ADDR=>$ENV{REMOTE_ADDR}||"",},_DSN=>{},_OBJECTS=>{},_DRIVER_ARGS=>{},_CLAIMED_ID=>undef,_STATUS=>STATUS_UNSET,_QUERY=>undef},$class;my($dsn,$query_or_sid,$dsn_args,$read_only,$params);if(@_==1){$self->_set_query_or_sid($_[0]);}elsif(@_>1){($dsn,$query_or_sid,$dsn_args,$read_only)=@_;if(ref$read_only and ref$read_only eq 'HASH'){$params={%$read_only};$read_only=$params->{'read_only'};if($params->{'name'}){$self->{_NAME}=$params->{'name'};}}if(defined$read_only and$read_only!='1'){return$class->set_error("Too many arguments to load(). First extra argument was: $read_only");}if(defined$dsn){$self->{_DSN}=$self->parse_dsn($dsn);}$self->_set_query_or_sid($query_or_sid);$self->{_DRIVER_ARGS}=$dsn_args if defined$dsn_args;}$self->_load_pluggables();return undef if$class->errstr;if(not defined$self->{_CLAIMED_ID}){my$query=$self->query();eval{$self->{_CLAIMED_ID}=$query->cookie($self->name)||$query->param($self->name);};if(my$errmsg=$@){return$class->set_error("query object $query does not support cookie() and param() methods: ".$errmsg);}}return$self unless$self->{_CLAIMED_ID};my$driver=$self->_driver();my$raw_data=$driver->retrieve($self->{_CLAIMED_ID});unless(defined$raw_data){return$self->set_error("load(): couldn't retrieve data: ".$driver->errstr);}return$self unless$raw_data;my$serializer=$self->_serializer();$self->{_DATA}=$serializer->thaw($raw_data);unless(defined$self->{_DATA}){return$self->set_error("load(): couldn't thaw() data using $serializer:".$serializer->errstr);}unless(defined($self->{_DATA})&&ref($self->{_DATA})&&(ref$self->{_DATA}eq 'HASH')&&defined($self->{_DATA}->{_SESSION_ID})){return$self->set_error("Invalid data structure returned from thaw()");}if($self->{_DATA}->{_SESSION_ETIME}){if(($self->{_DATA}->{_SESSION_ATIME}+$self->{_DATA}->{_SESSION_ETIME})<=time()){$self->_set_status(STATUS_EXPIRED|STATUS_DELETED);$self->flush();return$self;}}my@expired_params=();if($self->{_DATA}->{_SESSION_EXPIRE_LIST}){while(my($param,$max_exp_interval)=each%{$self->{_DATA}->{_SESSION_EXPIRE_LIST}}){if(($self->{_DATA}->{_SESSION_ATIME}+$max_exp_interval)<=time()){push@expired_params,$param;}}}$self->clear(\@expired_params)if@expired_params;if(not defined$read_only){if($CGI::Session::IP_MATCH){unless($self->ip_matches){$self->_set_status(STATUS_DELETED);$self->flush;return$self;}}$self->{_DATA}->{_SESSION_ATIME}=time();$self->_set_status(STATUS_MODIFIED);}return$self;}sub _set_query_or_sid{my$self=shift;my$query_or_sid=shift;if(ref$query_or_sid){$self->{_QUERY}=$query_or_sid}else{$self->{_CLAIMED_ID}=$query_or_sid}}sub _load_pluggables{my($self)=@_;my%DEFAULT_FOR=(driver=>"file",serializer=>"default",id=>"md5",);my%SUBDIR_FOR=(driver=>"Driver",serializer=>"Serialize",id=>"ID",);my$dsn=$self->{_DSN};for my$plug(qw(driver serializer id)){my$mod_name=$dsn->{$plug};if(not defined$mod_name){$mod_name=$DEFAULT_FOR{$plug};}if($mod_name=~/^(\w+)$/){$dsn->{$plug}=$mod_name=$1;my$prefix=join '::',(__PACKAGE__,$SUBDIR_FOR{$plug},q{});$mod_name=$prefix.$mod_name;eval"require $mod_name";if($@){my$msg=$@;return$self->set_error("couldn't load $mod_name: ".$msg);}}else{}}return;}*expires=\&expire;my$prevent_warning=\&expires;sub etime{$_[0]->expire()}sub expire{my$self=shift;if(not@_){return$self->{_DATA}->{_SESSION_ETIME};}elsif(@_==1){my$time=$_[0];if(defined$time&&($time=~m/^\d$/)&&($time==0)){$self->{_DATA}->{_SESSION_ETIME}=undef;$self->_set_status(STATUS_MODIFIED);}else{$self->{_DATA}->{_SESSION_ETIME}=$self->_str2seconds($time);$self->_set_status(STATUS_MODIFIED);}}else{my($param,$time)=@_;if(($time=~m/^\d$/)&&($time==0)){delete$self->{_DATA}->{_SESSION_EXPIRE_LIST}->{$param};$self->_set_status(STATUS_MODIFIED);}else{$self->{_DATA}->{_SESSION_EXPIRE_LIST}->{$param}=$self->_str2seconds($time);$self->_set_status(STATUS_MODIFIED);}}return 1;}sub _str2seconds{my$self=shift;my($str)=@_;return unless defined$str;return$str if$str=~m/^[-+]?\d+$/;my%_map=(s=>1,m=>60,h=>3600,d=>86400,w=>604800,M=>2592000,y=>31536000);my($koef,$d)=$str=~m/^([+-]?\d+)([smhdwMy])$/;unless(defined($koef)&&defined($d)){die"_str2seconds(): couldn't parse '$str' into \$koef and \$d parts. Possible invalid syntax";}return$koef*$_map{$d};}sub remote_addr{return$_[0]->{_DATA}->{_SESSION_REMOTE_ADDR}}1;