<?php
class phpfAgent{
	var $agent;
    var $vender;
    var $hasSubno;
    var $subno;
    /*
    * gets list of name of directories inside a directory
    */
    function &phpfAgent($agent) {
		$debug = 0;
		$this->agent = $agent;
		if(preg_match('{^DoCoMo/[12]\.0}', $agent)){
		  $this->vender = 'd';	// docomo
		  $utn = preg_replace("/[\s;]icc\d+/","",$agent);	//FOMA and MOVA
		  $utn = preg_replace("/[\s;]ser\d+/","",$utn);		//FOMA
		  $utn = preg_replace("/F\)+/",")",$utn);		//FOMA after subno
		  $this->agent = $utn;
		}elseif(preg_match('{^(J\-PHONE|Vodafone|MOT\-[CV]980|SoftBank)/}', $agent)){
		  $this->vender = 's';// softbank
		}elseif(preg_match('/^KDDI\-|UP\.Browser/', $agent)){
		  $this->vender = 'a';	// au
		}elseif(preg_match('/(DDIPOCKET|WILLCOM);/i', $agent)){
		  $this->vender = 'w';	// willcom
		} else {
		  $this->vender = 'p';	// pc
		}
		$this->setSubno($agent);
		if($debug){
			echo "Agent " . $this->agent . "<br />";
			echo "Vender " . $this->vender . "<br />";
			echo "HasSubNo " . $this->hasSubno . "<br />";
			echo "SubNo " . $this->subno . "<br />";
		}
		return $this->vender;
	}
    function &setSubno($agent) {
    	switch($this->vender){
    		case 'd':	//DoCoMo
				$this->hasSubno = preg_match('/ser[0-9A-Za-z]{11,15}/', $agent,$matches);
				break;
    		case 's':	//SoftBank
				$this->hasSubno = preg_match('/\/SN[0-9A-Za-z]{15}/', $agent,$matches);
				break;
    		case 'a':	//AU
				// 05051234567890_ae.ezweb.ne.jp
				// 4nR[h10[R[h
				$subno = $_SERVER['HTTP_X_UP_SUBNO'];
				$agent .= '/SUB'.substr($subno, 0, -12);
				$this->hasSubno = preg_match('/\/SUB0\d0\d\d{10}_[a-z\d]{2}$/', $agent,$matches);
				break;
			default:
				$this->hasSubno = 0;
    	}
    	if ($this->hasSubno==1) $this->subno = $matches[0];
		return $this->subno;
	}
}
?>