#!/bin/sh
# sitar proxy startup script
#
PATH=$PATH:/usr/sbin:/usr/local/zither/bin
LOG_PATH=/usr/local/zither/log
IN_IP=127.0.0.1
IN_PORT=9999
OUT_IP=127.0.0.1
OUT_PORT=9988
MAX_COUNT=10
USER_ID=`id -u zither`

start() {
        echo "start sitar proxy"
        sitar_proxy $IN_IP $IN_PORT $OUT_IP $OUT_PORT $MAX_COUNT $USER_ID 1> $LOG_PATH/proxy.log 2> $LOG_PATH/proxy.errlog &
}

stop() {
        echo "stop sitar client"
        killall sitar_proxy
}

case "$1" in
  start)
        start
        ;;
  stop)
        stop
        ;;
  restart|reload)
        stop
        sleep 20
        start
        ;;
  *)
        echo $"Usage: $0 {start|stop|restart}"
        exit 1
esac
 
exit 0  
 
