/** 
 * time_format.c 
 * Masashi Shimakura
 * 15 01 2008 
**/

#include<stdio.h>
#include<stdlib.h>
#include<string.h>


#include<almemsys/almemsys.h>

// #define TIME_FORMAT_BUG

/**
 * 1 00:00:00:00:00 年月日時分の文字列、
 * 年の戻り
 * 月の戻り
 * 日の戻り
 * 時の戻り
 * 分の戻り
 * 戻り値は1の場合はエラーあり、0はエラーなし
**/
// int time_format(char *, int *, int *, int *, int *, int *);

//
// 時間のふぉーまっとについて
// 0 == 0
// 24 == 0 
// 100 の場合は時間を無視します
// 通常は1,2,3,4,5,6,,,,,24 
// 200==日 201==月 202==火 203==水 204==木 205金 206==土
//



int time_format(char * data, int * ye, int * mo, int * da, int * ha, int * mi)
{
char * swap;
char * swap2;
int ret;
ret = 0;

swap = (char *)calloc(2, (sizeof(char)));
swap2 = (char *)calloc(2, (sizeof(char)));

// データサイズが0ならリターン
if(0 == (int)strlen(data)){
   ret = -1;
   fprintf(stderr,"time_format(): time_format data size err. %s\n", data);
   free(swap);
   free(swap2);
   return ret;
   }

// 全体が数字と：で構成されていない場合はリターン
if(0 != ch_int3(data, ':')){
   ret = -1;
   fprintf(stderr,"time_format(): time_format format strings err. %s\n", data);
   free(swap);
   free(swap2);
   return ret;
   }

// もし：が5個以上あるならリターン
if(4 < char_count(data, ':')){
   ret = -1;
   fprintf(stderr,"time_format(): time_format : format err. %s\n", data);
   free(swap);
   free(swap2);
   return ret;
   }


// 全体が数字だけの場合は頭を追加
if(0 == ch_int2(data)){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100:100:100:100:%s", data);
   }
// 後端が：の場合は00でフォーマット
else if(data[(int)strlen(data) - 1] == ':'){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100:100:100:100:100", data);
   }
// 一つだけ：があるが、先頭が数字の場合に100:100:を追加
else if(1 == char_count(data, ':') && data[0] != ':'){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100:100:100:%s", data);
   }
// 一つだけ：があるが、先頭が数字でない場合に100:100:100を追加
else if(1 == char_count(data, ':') && data[0] == ':'){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100:100:100:100%s", data);
   }

// 二つだけ：があるが、先頭が数字の場合に100:100:を追加
else if(2 == char_count(data, ':') && data[0] != ':'){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100:100:%s", data);
   }
// 二つだけ：があるが、先頭が数字でない場合に100:100:100を追加
else if(2 == char_count(data, ':') && data[0] == ':'){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100:100:100%s", data);
   }

// 三つだけ：があるが、先頭が数字の場合に100:を追加
else if(3 == char_count(data, ':') && data[0] != ':'){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100:%s", data);
   }
// 三つだけ：があるが、先頭が数字でない場合に100:100を追加
else if(3 == char_count(data, ':') && data[0] == ':'){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100:100%s", data);
   }

// 4っだけ：があるが、先頭が数字でない場合に100を追加
else if(4 == char_count(data, ':') && data[0] == ':'){
   swap2 = safe_sprintf(swap2, BUF_MAX,"100%s", data);
   }


else{
   swap2 = safe_memcpy(swap2, data, BUF_MAX);
   // これ以上は救済しません。
   }


#ifdef TIME_FORMAT_BUG
printf("-------%s--------\n", swap2);
#endif


swap = delim_get(swap2, swap, ':', &ret, 0);
if(ret >= 0){
   * ye = strtol(swap, (char **)NULL, 10);
   swap = safe_memcpy(swap, "", BUF_MAX);
   swap = delim_get(swap2, swap, ':', &ret, 1);
   if(ret >= 0){
      * mo = strtol(swap, (char **)NULL, 10);
      swap = safe_memcpy(swap, "", BUF_MAX);
      swap = delim_get(swap2, swap, ':', &ret, 2);
      if(ret >= 0){
         * da = strtol(swap, (char **)NULL, 10);
         swap = safe_memcpy(swap, "", BUF_MAX);
         swap = delim_get(swap2, swap, ':', &ret, 3);
         if(ret >= 0){
            * ha = strtol(swap, (char **)NULL, 10);
            swap = safe_memcpy(swap, "", BUF_MAX);
            swap = delim_get(swap2, swap, ':', &ret, 4);
            if(ret >= 0){
               * mi = strtol(swap, (char **)NULL, 10);
               swap = safe_memcpy(swap, "", BUF_MAX);
               #ifdef TIME_FORMAT_BUG
               printf("time_format(): 正常終了です ye=%d, mo=%d, da=%d, ha=%d, mi=%d ret=%d\n",
                 * ye, * mo, * da, * ha, * mi, ret);
               #endif
               }
            else{
               fprintf(stderr,"time_format(): 分の評価が不良です\n");
               ret = -1;
               }
            }
         else{
            fprintf(stderr,"time_format(): 時の評価が不良です\n");
            ret = -1;
            }
         }
      else{
         fprintf(stderr,"time_format(): 日日の評価が不良です\n");
         ret = -1;
         }
      }
   else{
      fprintf(stderr,"time_format(): 月の評価が不良です\n");
      ret = -1;
      }
   }
else{
   fprintf(stderr,"time_format(): 年の評価が不良です\n");
   ret = -1;
   }

#ifdef TIME_FORMAT_BUG
printf("(1): ye = %d, mo = %d, da = %d, ha = %d, mi = %d ret = %d\n", * ye, * mo, * da, * ha, * mi, ret);
#endif 

if(* mi == 100){
   * ye = 100; * mo = 100; * da = 100; * ha = 100;
   }
else if(* ha == 100){
   * ye = 100; * mo = 100; * da = 100;
   }
else if(* da == 100){
   * ye = 100; * mo = 100;
   }
else if(* mo == 100){
   * ye = 100;
   }

#ifdef TIME_FORMAT_BUG
printf("(2): ye = %d, mo = %d, da = %d, ha = %d, mi = %d ret = %d\n", * ye, * mo, * da, * ha, * mi, ret);
#endif 

free(swap);
free(swap2);
return ret;
}






