
#include<stdio.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h>
#include<time.h>
#include<errno.h>

#include"zither.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"


extern global_data_t gd;





// zither main()カラ最初ニ分岐スルスレッド
int connect_open(int fdno)
{
int stat = 0;
int ret = 0;
int neg = 0;
private_data_t *pd;

if((pd = (private_data_t *)malloc(sizeof(private_data_t)))==NULL){exit(1);}
private_malloc_set(pd);
pd->rec.fdno = fdno;

pthread_detach(pthread_self());

/*  Processing description as follows  */

pd->getdata = select_fdcat(gd.ms.sk[pd->rec.fdno], pd->getdata, &stat, BUF_MAX, 15);

if(stat >= 0){
   neg = start_neg(pd);
   #ifdef DATA_SIZE
   printf("DATA_SIZE: connect_open(): start_neg %d\n", neg);
   #endif
   if(neg >= 1){
      #ifdef POSTGRES_IN
      psql_connectset(pd, "ON");
      #endif
      #ifdef MYSQL_IN
      mysql_connectset(pd, "ON");
      #endif
      for(;ret >= 0;){
         pd->getdata = select_fdcat(gd.ms.sk[pd->rec.fdno], pd->getdata, &ret, BUF_MAX,
                                     (pd->life.life_int + pd->life.life_los + 15));
         #ifdef DATA_SIZE
         printf("DATA_SIZE: connect_open(): select_fdcat stat %d\n", ret);
         #endif
         if(ret >= 0){
            ret = stag_neg(pd);
            #ifdef DATA_SIZE
            printf("DATA_SIZE: connect_open(): stag_neg stat %d\n", ret);
            #endif
            }

         } /* for */
      }
   }
else{
   #ifdef THREAD_BUG
   fprintf(stderr,"THREAD_BUG: connect_open(): 正常に認証を通過しない接続なのでスレッドを破棄します fdn = %d\n",
      pd->rec.fdno);
   #endif
   gd.ms.fdstat[pd->rec.fdno] = 0;
   close(gd.ms.sk[pd->rec.fdno]);
   private_malloc_free(pd);
   free(pd);
   return 0;
   }


/*  Here  */

#ifdef THREAD_BUG
fprintf(stderr,"THREAD_BUG: connect_open(): スレッド番号.%d　がデタッチされました\n", fdno);
#endif

fprintf(stdout,"connect_open(): break loop or not connection. FD=%d USER=%s\n", pd->rec.fdno, pd->rec.user);
fprintf(stdout,"connect_open(): break loop life.cancel no is ->%d\n", pd->life.cancel);

if(pd->life.in_life[0] > 0){
   pd->life.cancel = -1;
   fprintf(stderr,"connect_open(): The thread is canceled. FD=%d USER=%s\n",  pd->rec.fdno, pd->rec.user);
   }


if(neg >= 1){

   #ifdef POSTGRES_IN
   char * pgerrlog_table = "(cip,cname,monitor,uct,ye,mo,da,ha,mi,se,sign,proto,com,cinfo,port,wtime,pinfo,errdata,prino,free1,free2,free3,free4)"; 
   char * swap = (char *)calloc(2, sizeof(char));
   swap = safe_sprintf(swap, BUF_MAX, "%s%s%s('%d.%d.%d.%d', '%s', '%s', '%ld', '%ld', '%ld', '%ld' , '%ld', '%ld', '%ld', '%ld', '%s', '%s', '%s', '%ld', '%ld', '%s', '%s', '%ld', '%s', '%s', '%s', '%s');",
      "INSERT INTO errlog ",
      pgerrlog_table,
      " VALUES ",
      gd.ms.inip_addr[pd->rec.fdno][0],
      gd.ms.inip_addr[pd->rec.fdno][1],
      gd.ms.inip_addr[pd->rec.fdno][2],
      gd.ms.inip_addr[pd->rec.fdno][3],

      pd->rec.user,
      "CLOSE",
      (long int)time(NULL),
      ctime_getr('y'),
      ctime_getr('m'),
      ctime_getr('d'),
      ctime_getr('h'),
      ctime_getr('i'),
      ctime_getr('s'),
      0,
      "NOT",
      "NOT",
      "NOT",
      0,
      0,
      pd->rec.info,
      "sitar client shutdown.",
      1,
      "NON",
      "NON",
      "NON",
      "NON");

   pthread_mutex_lock(&pg_mutex);
   psqlexec_datain(swap);
   pthread_mutex_unlock(&pg_mutex);
   #ifdef POSTGRES_DEBUG
   printf("POSTGRES_DEBUG: connect_open(): >>%s\n", swap);
   #endif

   psql_connectset(pd, "OFF");

   free(swap);
   #endif   /* POSTGRES_IN */








   #ifdef MYSQL_IN
   char * myerrlog_table = "(cip,cname,monitor,uct,ye,mo,da,ha,mi,se,sign,proto,com,cinfo,port,wtime,pinfo,errdata,prino,free1,free2,free3,free4)"; 
   char * myswap = (char *)calloc(2, sizeof(char));
   myswap = safe_sprintf(myswap, BUF_MAX, "%s%s%s('%d.%d.%d.%d','%s','%s','%ld','%ld','%ld','%ld','%ld','%ld','%ld','%ld','%s','%s','%s','%ld','%ld','%s','%s','%ld','%s','%s','%s','%s');",
      "INSERT INTO errlog ",
      myerrlog_table,
      " VALUES ",
      gd.ms.inip_addr[pd->rec.fdno][0],
      gd.ms.inip_addr[pd->rec.fdno][1],
      gd.ms.inip_addr[pd->rec.fdno][2],
      gd.ms.inip_addr[pd->rec.fdno][3],
      pd->rec.user,
      "CLOSE",
      (long int)time(NULL),
      ctime_getr('y'),
      ctime_getr('m'),
      ctime_getr('d'),
      ctime_getr('h'),
      ctime_getr('i'),
      ctime_getr('s'),
      0,
      "NOT",
      "NOT",
      "NOT",
      0,
      0,
      pd->rec.info,
      "sitar client shutdown.",
      1,
      "NON",
      "NON",
      "NON",
      "NON");

   pthread_mutex_lock(&mysql_mutex);
   mysqlexec_datain(myswap);
   pthread_mutex_unlock(&mysql_mutex);
   #ifdef MYSQL_DEBUG
   printf("MYSQL_DEBUG: connect_open(): >>%s\n", myswap);
   #endif

   mysql_connectset(pd, "OFF");

   free(myswap);
   #endif   /* MYSQL_IN */




   if(gd.md.in_mailonoff == 1){
      if(0 == self_memcmp(pd->rec.def_user, "administrator")){
         mail_grsend(pd->mail.server,
              pd->mail.from,
              pd->mail.rcptto,
              pd->mail.cc,
              pd->rec.def_user,
              pd->rec.info,
              ADMIN_BODY_1,
              ADMIN_BODY_2,
              CL_VAR);
         }
      else{
         mail_grsend(pd->mail.server,
              pd->mail.from,
              pd->mail.rcptto,
              pd->mail.cc,
              pd->rec.def_user,
              pd->rec.info,
              CLIENT_BODY_1,
              CLIENT_BODY_2,
              CL_VAR);
         }
      }


   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, pd->rec.data,
     "Zither server connection is lost.", gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif

   sleep(2);

   lock_remove(pd->file.lock_filename);
   pd->file.clock_filename = chack_lockfile(pd->rec.user, pd->rec.info, pd->file.clock_filename, gd.fp.clock_path, &stat);
   if(0 == self_memcmp(pd->rec.user, "administrator")){
      lock_remove(pd->file.clock_filename);
      fprintf(stderr,"connect_open(): removd administrator lock file <%s>\n", pd->file.clock_filename);
      }

   } /* neg stat = -1 */


gd.ms.fdstat[pd->rec.fdno] = 0;
close(gd.ms.sk[pd->rec.fdno]);

fprintf(stderr,"connect_open(): thread Management number %d fd openings. <%s>\n",
   pd->rec.fdno, pd->rec.user);
fprintf(stderr,"connect_open(): thread Management number %d plivate memory openings. <%s>\n",
   pd->rec.fdno, pd->rec.user);


private_malloc_free(pd);
free(pd);

return 0;
}







